<?php $__env->startSection('title', 'Style Predictions Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3">Style Predictions Management</h1>
            <p class="text-muted">Manage future fashion predictions and trend forecasts</p>
        </div>
        <div>
            <a href="<?php echo e(route('trends.predictions')); ?>" class="btn btn-info me-2" target="_blank">
                <i class="fas fa-eye me-2"></i>View Live
            </a>
            <a href="<?php echo e(route('admin.trends.create-predictions')); ?>" class="btn btn-success">
                <i class="fas fa-plus me-2"></i>Add New Prediction
            </a>
        </div>
    </div>

    <!-- Predictions Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-start border-primary border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-primary text-uppercase mb-1">Total Predictions</div>
                            <div class="h5"><?php echo e(count($stylePredictions)); ?></div>
                        </div>
                        <i class="fas fa-crystal-ball fa-2x text-primary"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-success border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-success text-uppercase mb-1">2024 Predictions</div>
                            <div class="h5"><?php echo e(collect($stylePredictions)->where('year', 2024)->count()); ?></div>
                        </div>
                        <i class="fas fa-calendar-check fa-2x text-success"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-warning border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-warning text-uppercase mb-1">2025 Predictions</div>
                            <div class="h5"><?php echo e(collect($stylePredictions)->where('year', 2025)->count()); ?></div>
                        </div>
                        <i class="fas fa-calendar-plus fa-2x text-warning"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-info border-4">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-grow-1">
                            <div class="small fw-bold text-info text-uppercase mb-1">High Confidence</div>
                            <div class="h5"><?php echo e(collect($stylePredictions)->where('confidence', '>=', 80)->count()); ?></div>
                        </div>
                        <i class="fas fa-chart-line fa-2x text-info"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Style Predictions List -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Style Predictions</h5>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th style="width: 80px;">Image</th>
                            <th>Prediction</th>
                            <th style="width: 100px;">Category</th>
                            <th style="width: 80px;">Year</th>
                            <th style="width: 100px;">Confidence</th>
                            <th style="width: 120px;">Impact Level</th>
                            <th style="width: 150px;" class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $stylePredictions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prediction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($prediction['image'])); ?>" 
                                     class="rounded" 
                                     style="width: 60px; height: 60px; object-fit: cover;" 
                                     alt="<?php echo e($prediction['title']); ?>">
                            </td>
                            <td>
                                <h6 class="mb-1"><?php echo e($prediction['title']); ?></h6>
                                <p class="text-muted small mb-0"><?php echo e(Str::limit($prediction['description'], 100)); ?></p>
                            </td>
                            <td>
                                <span class="badge 
                                    <?php if($prediction['category'] === 'Technology'): ?> bg-primary
                                    <?php elseif($prediction['category'] === 'Sustainability'): ?> bg-success
                                    <?php elseif($prediction['category'] === 'Materials'): ?> bg-info
                                    <?php else: ?> bg-warning text-dark
                                    <?php endif; ?>
                                ">
                                    <?php if($prediction['category'] === 'Technology'): ?>
                                        <i class="fas fa-microchip me-1"></i>
                                    <?php elseif($prediction['category'] === 'Sustainability'): ?>
                                        <i class="fas fa-leaf me-1"></i>
                                    <?php elseif($prediction['category'] === 'Materials'): ?>
                                        <i class="fas fa-vial me-1"></i>
                                    <?php else: ?>
                                        <i class="fas fa-palette me-1"></i>
                                    <?php endif; ?>
                                    <?php echo e($prediction['category']); ?>

                                </span>
                            </td>
                            <td>
                                <span class="fw-bold"><?php echo e($prediction['year']); ?></span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="progress me-2" style="width: 60px; height: 20px;">
                                        <div class="progress-bar 
                                            <?php if($prediction['confidence'] >= 80): ?> bg-success
                                            <?php elseif($prediction['confidence'] >= 60): ?> bg-warning
                                            <?php else: ?> bg-danger
                                            <?php endif; ?>
                                        " 
                                        style="width: <?php echo e($prediction['confidence']); ?>%"></div>
                                    </div>
                                    <small class="fw-bold"><?php echo e($prediction['confidence']); ?>%</small>
                                </div>
                            </td>
                            <td>
                                <span class="badge 
                                    <?php if($prediction['impact_level'] === 'Revolutionary'): ?> bg-danger
                                    <?php elseif($prediction['impact_level'] === 'Significant'): ?> bg-warning text-dark
                                    <?php else: ?> bg-info
                                    <?php endif; ?>
                                ">
                                    <?php if($prediction['impact_level'] === 'Revolutionary'): ?>
                                        <i class="fas fa-rocket me-1"></i>
                                    <?php elseif($prediction['impact_level'] === 'Significant'): ?>
                                        <i class="fas fa-star me-1"></i>
                                    <?php else: ?>
                                        <i class="fas fa-wave-square me-1"></i>
                                    <?php endif; ?>
                                    <?php echo e($prediction['impact_level']); ?>

                                </span>
                            </td>
                            <td class="text-center">
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('trends.predictions')); ?>#<?php echo e($prediction['slug']); ?>" 
                                       class="btn btn-sm btn-outline-info" title="View" target="_blank">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.trends.edit-predictions', $prediction['slug'])); ?>" 
                                       class="btn btn-sm btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                            onclick="confirmDelete('<?php echo e($prediction['slug']); ?>', '<?php echo e($prediction['title']); ?>')" 
                                            title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-5">
                                <i class="fas fa-crystal-ball fa-3x text-muted mb-3"></i>
                                <p class="text-muted">No style predictions found. Create your first prediction to get started!</p>
                                <a href="<?php echo e(route('admin.trends.create-predictions')); ?>" class="btn btn-success">
                                    <i class="fas fa-plus me-2"></i>Add New Prediction
                                </a>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Predictions Analytics -->
    <div class="row mt-4">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Prediction Timeline</h6>
                </div>
                <div class="card-body">
                    <?php
                        $years = collect($stylePredictions)->groupBy('year')->sortKeys();
                    ?>
                    
                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year => $yearPredictions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row mb-4">
                        <div class="col-2">
                            <div class="text-center">
                                <div class="badge bg-primary fs-6"><?php echo e($year); ?></div>
                            </div>
                        </div>
                        <div class="col-10">
                            <div class="row">
                                <?php $__currentLoopData = $yearPredictions->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prediction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <div class="card border-0 bg-light">
                                        <div class="card-body p-3">
                                            <h6 class="small mb-1"><?php echo e(Str::limit($prediction['title'], 40)); ?></h6>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <small class="text-muted"><?php echo e($prediction['category']); ?></small>
                                                <span class="badge bg-success"><?php echo e($prediction['confidence']); ?>%</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Confidence Overview</h6>
                </div>
                <div class="card-body">
                    <?php
                        $highConfidence = collect($stylePredictions)->where('confidence', '>=', 80)->count();
                        $mediumConfidence = collect($stylePredictions)->whereBetween('confidence', [60, 79])->count();
                        $lowConfidence = collect($stylePredictions)->where('confidence', '<', 60)->count();
                        $total = count($stylePredictions);
                    ?>
                    
                    <div class="mb-3">
                        <div class="d-flex justify-content-between">
                            <small>High Confidence (80%+)</small>
                            <small><?php echo e($highConfidence); ?></small>
                        </div>
                        <div class="progress mb-2" style="height: 8px;">
                            <div class="progress-bar bg-success" style="width: <?php echo e($total > 0 ? ($highConfidence / $total * 100) : 0); ?>%"></div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="d-flex justify-content-between">
                            <small>Medium Confidence (60-79%)</small>
                            <small><?php echo e($mediumConfidence); ?></small>
                        </div>
                        <div class="progress mb-2" style="height: 8px;">
                            <div class="progress-bar bg-warning" style="width: <?php echo e($total > 0 ? ($mediumConfidence / $total * 100) : 0); ?>%"></div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="d-flex justify-content-between">
                            <small>Low Confidence (<60%)</small>
                            <small><?php echo e($lowConfidence); ?></small>
                        </div>
                        <div class="progress mb-2" style="height: 8px;">
                            <div class="progress-bar bg-danger" style="width: <?php echo e($total > 0 ? ($lowConfidence / $total * 100) : 0); ?>%"></div>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="mt-3">
                        <h6 class="small fw-bold">Key Categories:</h6>
                        <div class="d-flex flex-wrap gap-1">
                            <span class="badge bg-primary">Technology</span>
                            <span class="badge bg-success">Sustainability</span>
                            <span class="badge bg-info">Materials</span>
                            <span class="badge bg-warning text-dark">Color Trends</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete the prediction "<span id="deletePredictionTitle"></span>"?</p>
                <p class="text-muted small">This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete Prediction</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(slug, title) {
    document.getElementById('deletePredictionTitle').textContent = title;
    document.getElementById('deleteForm').action = `/admin/trends/predictions/${slug}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/admin/trends/predictions.blade.php ENDPATH**/ ?>