
<?php $__env->startSection('title', 'Coupons'); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>Coupons Management</h1>
    <a href="<?php echo e(route('admin.coupons.create')); ?>" class="btn btn-primary">Add Coupon</a>
    <table class="table mt-3">
        <thead>
            <tr>
                <th>Code</th>
                <th>Type</th>
                <th>Amount</th>
                <th>Valid Until</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($coupon->code); ?></td>
                <td><?php echo e($coupon->discount_type); ?></td>
                <td><?php echo e($coupon->discount_amount); ?></td>
                <td><?php echo e($coupon->valid_until->format('Y-m-d')); ?></td>
                <td><?php echo e($coupon->is_active ? 'Active' : 'Inactive'); ?></td>
                <td>
                    <a href="<?php echo e(route('admin.coupons.edit', $coupon)); ?>" class="btn btn-sm btn-warning">Edit</a>
                    <form action="<?php echo e(route('admin.coupons.destroy', $coupon)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-sm btn-danger" onclick="return confirm('Delete?')">Delete</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php echo e($coupons->links()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/coupons/index.blade.php ENDPATH**/ ?>