<!-- register.blade.php -->


<?php $__env->startSection('title', 'Register'); ?>
<?php $__env->startSection('meta_description', 'Create your Edition By Punjab account'); ?>

<?php $__env->startSection('content'); ?>
<div class="auth-page-premium">
    <div class="auth-background">
        <div class="auth-pattern"></div>
        <div class="auth-gradient"></div>
    </div>
    
    <div class="container">
        <div class="auth-container auth-container-wide" data-aos="zoom-in">
            <div class="auth-card-premium">
                <!-- Logo Section -->
                <div class="auth-header">
                    <h2 class="auth-title">Create Account</h2>
                    <p class="auth-subtitle">Join Edition By Punjab today</p>
                </div>

                <!-- Register Form -->
                <form method="POST" action="<?php echo e(route('register')); ?>" class="auth-form-premium">
                    <?php echo csrf_field(); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group-auth">
                                <label for="name" class="form-label-auth">Full Name</label>
                                <div class="input-group-auth">
                                    <span class="input-icon"><i class="fas fa-user"></i></span>
                                    <input id="name" 
                                           type="text" 
                                           class="form-control-auth <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           name="name" 
                                           value="<?php echo e(old('name')); ?>" 
                                           placeholder="Enter your full name"
                                           required 
                                           autocomplete="name" 
                                           autofocus>
                                </div>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-text"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group-auth">
                                <label for="phone" class="form-label-auth">Phone (Optional)</label>
                                <div class="input-group-auth">
                                    <span class="input-icon"><i class="fas fa-phone"></i></span>
                                    <input id="phone" 
                                           type="tel" 
                                           class="form-control-auth <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           name="phone" 
                                           value="<?php echo e(old('phone')); ?>" 
                                           placeholder="Enter your phone"
                                           autocomplete="tel">
                                </div>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-text"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="form-group-auth">
                        <label for="email" class="form-label-auth">Email Address</label>
                        <div class="input-group-auth">
                            <span class="input-icon"><i class="fas fa-envelope"></i></span>
                            <input id="email" 
                                   type="email" 
                                   class="form-control-auth <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="email" 
                                   value="<?php echo e(old('email')); ?>" 
                                   placeholder="Enter your email"
                                   required 
                                   autocomplete="email">
                        </div>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error-text"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group-auth">
                                <label for="password" class="form-label-auth">Password</label>
                                <div class="input-group-auth">
                                    <span class="input-icon"><i class="fas fa-lock"></i></span>
                                    <input id="password" 
                                           type="password" 
                                           class="form-control-auth <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           name="password" 
                                           placeholder="Create password"
                                           required 
                                           autocomplete="new-password">
                                    <button type="button" class="password-toggle-auth" onclick="toggleAuthPassword('password')">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-text"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group-auth">
                                <label for="password-confirm" class="form-label-auth">Confirm Password</label>
                                <div class="input-group-auth">
                                    <span class="input-icon"><i class="fas fa-lock"></i></span>
                                    <input id="password-confirm" 
                                           type="password" 
                                           class="form-control-auth" 
                                           name="password_confirmation" 
                                           placeholder="Confirm password"
                                           required 
                                           autocomplete="new-password">
                                    <button type="button" class="password-toggle-auth" onclick="toggleAuthPassword('password-confirm')">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Password Strength Indicator -->
                    <div class="password-strength-auth" id="passwordStrengthAuth" style="display: none;">
                        <div class="strength-bar-auth">
                            <div class="strength-fill-auth" id="strengthFillAuth"></div>
                        </div>
                        <div class="strength-info">
                            <span class="strength-text-auth" id="strengthTextAuth">Weak</span>
                            <span class="strength-tips">Use 8+ characters with mixed case, numbers & symbols</span>
                        </div>
                    </div>

                    <div class="form-group-auth">
                        <div class="form-check-auth">
                            <input class="check-input-auth" 
                                   type="checkbox" 
                                   id="terms" 
                                   name="terms" 
                                   required>
                            <label class="check-label-auth" for="terms">
                                I agree to the <a href="<?php echo e(route('terms')); ?>" target="_blank">Terms of Service</a> 
                                and <a href="<?php echo e(route('privacy')); ?>" target="_blank">Privacy Policy</a>
                            </label>
                        </div>
                        
                        <div class="form-check-auth">
                            <input class="check-input-auth" 
                                   type="checkbox" 
                                   id="newsletter" 
                                   name="newsletter">
                            <label class="check-label-auth" for="newsletter">
                                Send me exclusive offers and updates
                            </label>
                        </div>
                    </div>

                    <button type="submit" class="btn-auth-submit">
                        <span class="btn-text">CREATE ACCOUNT</span>
                        <i class="fas fa-arrow-right"></i>
                    </button>
                </form>

                <!-- Login Link -->
                <div class="auth-footer">
                    <p>Already have an account?</p>
                    <a href="<?php echo e(route('login')); ?>" class="auth-link">
                        Login to Your Account
                        <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Auth Page Styles */
.auth-page-premium {
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    padding: 2rem 0;
}

.auth-background {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    overflow: hidden;
}

.auth-pattern {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-image: repeating-linear-gradient(
        45deg,
        transparent,
        transparent 35px,
        rgba(0,0,0,.02) 35px,
        rgba(0,0,0,.02) 70px
    );
}

.auth-gradient {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, #000 0%, #333 100%);
    opacity: 0.95;
}

.auth-container {
    position: relative;
    z-index: 1;
    width: 100%;
    max-width: 480px;
    margin: 0 auto;
}

.auth-card-premium {
    background: white;
    padding: 3rem;
    box-shadow: 0 20px 60px rgba(0,0,0,0.3);
    overflow: hidden;
    position: relative;
}

.auth-card-premium::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 5px;
    background: linear-gradient(90deg, #000 0%, #666 50%, #000 100%);
    animation: shimmer 2s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

/* Auth Header */
.auth-header {
    text-align: center;
    margin-bottom: 2.5rem;
}

.auth-logo {
    height: 60px;
    margin-bottom: 1.5rem;
}

.auth-title {
    font-size: 2rem;
    font-weight: 800;
    color: #000;
    margin-bottom: 0.5rem;
    font-family: 'Space Grotesk', sans-serif;
}

.auth-subtitle {
    color: #666;
}

/* Form Elements */
.form-group-auth {
    margin-bottom: 1.5rem;
}

.form-label-auth {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #333;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.input-group-auth {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #999;
    border-right: 1px solid #e0e0e0;
}

.form-control-auth {
    width: 100%;
    padding: 1rem 1rem 1rem 60px;
    border: 2px solid #e0e0e0;
    font-size: 1rem;
    transition: all 0.3s;
}

.form-control-auth:focus {
    outline: none;
    border-color: #000;
    box-shadow: 0 0 0 3px rgba(0,0,0,0.05);
}

.form-control-auth.is-invalid {
    border-color: #f44336;
}

.password-toggle-auth {
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    background: none;
    border: none;
    color: #999;
    cursor: pointer;
    transition: color 0.3s;
}

.password-toggle-auth:hover {
    color: #333;
}

.error-text {
    display: block;
    color: #f44336;
    font-size: 0.875rem;
    margin-top: 0.5rem;
}

/* Form Options */
.form-options {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
}

.form-check-auth {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.check-input-auth {
    width: 18px;
    height: 18px;
    cursor: pointer;
}

.check-label-auth {
    cursor: pointer;
    user-select: none;
    font-size: 0.875rem;
}

.forgot-link {
    color: #666;
    text-decoration: none;
    font-size: 0.875rem;
    transition: color 0.3s;
}

.forgot-link:hover {
    color: #000;
}

/* Submit Button */
.btn-auth-submit {
    width: 100%;
    padding: 1rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 700;
    letter-spacing: 0.1em;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    position: relative;
    overflow: hidden;
}

.btn-auth-submit::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.btn-auth-submit:hover::before {
    left: 100%;
}

.btn-auth-submit:hover {
    background: #333;
    transform: translateY(-2px);
}

/* Auth Divider */
.auth-divider {
    text-align: center;
    margin: 2rem 0;
    position: relative;
}

.auth-divider::before,
.auth-divider::after {
    content: '';
    position: absolute;
    top: 50%;
    width: calc(50% - 30px);
    height: 1px;
    background: #e0e0e0;
}

.auth-divider::before {
    left: 0;
}

.auth-divider::after {
    right: 0;
}

.auth-divider span {
    padding: 0 1rem;
    background: white;
    color: #999;
    font-size: 0.875rem;
}

/* Social Auth */
.social-auth {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.btn-social {
    padding: 0.875rem;
    background: white;
    border: 2px solid #e0e0e0;
    color: #333;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.75rem;
}

.btn-social:hover {
    transform: translateY(-2px);
}

.btn-social.google:hover {
    background: #4285F4;
    border-color: #4285F4;
    color: white;
}

.btn-social.facebook:hover {
    background: #1877F2;
    border-color: #1877F2;
    color: white;
}

/* Auth Footer */
.auth-footer {
    text-align: center;
    margin-top: 2rem;
    padding-top: 2rem;
    border-top: 1px solid #e0e0e0;
}

.auth-footer p {
    color: #666;
    margin-bottom: 0.5rem;
}

.auth-link {
    color: #000;
    text-decoration: none;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.3s;
}

.auth-link:hover {
    transform: translateX(5px);
    color: #333;
}

/* Responsive */
@media (max-width: 576px) {
    .auth-card-premium {
        padding: 2rem 1.5rem;
    }
    
    .auth-title {
        font-size: 1.5rem;
    }
}

/* Additional styles for register page */
.auth-container-wide {
    max-width: 600px;
}

.password-strength-auth {
    margin-bottom: 1.5rem;
    padding: 1rem;
    background: #f8f8f8;
    border-radius: 8px;
}

.strength-bar-auth {
    height: 6px;
    background: #e0e0e0;
    border-radius: 3px;
    overflow: hidden;
    margin-bottom: 0.75rem;
}

.strength-fill-auth {
    height: 100%;
    transition: all 0.3s;
    border-radius: 3px;
}

.strength-fill-auth.weak {
    width: 25%;
    background: #f44336;
}

.strength-fill-auth.fair {
    width: 50%;
    background: #FFB800;
}

.strength-fill-auth.good {
    width: 75%;
    background: #2196F3;
}

.strength-fill-auth.strong {
    width: 100%;
    background: #4CAF50;
}

.strength-info {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.strength-text-auth {
    font-weight: 600;
    font-size: 0.875rem;
}

.strength-tips {
    font-size: 0.75rem;
    color: #666;
}

.form-check-auth a {
    color: #000;
    text-decoration: underline;
}

.form-check-auth a:hover {
    text-decoration: none;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleAuthPassword(fieldId) {
    const field = document.getElementById(fieldId);
    const icon = field.parentElement.querySelector('.password-toggle-auth i');
    
    if (field.type === 'password') {
        field.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        field.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// Password strength checker for registration
document.getElementById('password')?.addEventListener('input', function() {
    const password = this.value;
    const strengthDiv = document.getElementById('passwordStrengthAuth');
    const strengthFill = document.getElementById('strengthFillAuth');
    const strengthText = document.getElementById('strengthTextAuth');
    
    if (password.length > 0) {
        strengthDiv.style.display = 'block';
        
        let strength = 0;
        if (password.length >= 8) strength++;
        if (password.match(/[a-z]/)) strength++;
        if (password.match(/[A-Z]/)) strength++;
        if (password.match(/[0-9]/)) strength++;
        if (password.match(/[^a-zA-Z0-9]/)) strength++;
        
        strengthFill.className = 'strength-fill-auth';
        
        if (strength <= 2) {
            strengthFill.classList.add('weak');
            strengthText.textContent = 'Weak';
            strengthText.style.color = '#f44336';
        } else if (strength === 3) {
            strengthFill.classList.add('fair');
            strengthText.textContent = 'Fair';
            strengthText.style.color = '#FFB800';
        } else if (strength === 4) {
            strengthFill.classList.add('good');
            strengthText.textContent = 'Good';
            strengthText.style.color = '#2196F3';
        } else {
            strengthFill.classList.add('strong');
            strengthText.textContent = 'Strong';
            strengthText.style.color = '#4CAF50';
        }
    } else {
        strengthDiv.style.display = 'none';
    }
});

// Form submission animation
document.querySelector('.auth-form-premium')?.addEventListener('submit', function(e) {
    const button = this.querySelector('.btn-auth-submit');
    const isLogin = button.querySelector('.btn-text').textContent === 'LOGIN';
    button.innerHTML = `<i class="fas fa-spinner fa-spin"></i> ${isLogin ? 'Logging in...' : 'Creating account...'}`;
    button.disabled = true;
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/auth/register.blade.php ENDPATH**/ ?>