<?php $__env->startSection('title', 'Fashion Trends & News - Edition By Punjab'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-0">
    <!-- Hero Section with Featured Trend -->
    <section class="featured-trend-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-7">
                    <div class="hero-content">
                        <span class="badge bg-warning text-dark mb-3 px-3 py-2">
                            <i class="fas fa-fire me-1"></i> <?php echo e($featuredTrend['category']); ?>

                        </span>
                        <h1 class="display-4 fw-bold mb-4"><?php echo e($featuredTrend['title']); ?></h1>
                        <p class="lead mb-4"><?php echo e($featuredTrend['excerpt']); ?></p>
                        <div class="d-flex align-items-center gap-4 mb-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-user-circle me-2"></i>
                                <span><?php echo e($featuredTrend['author']); ?></span>
                            </div>
                            <div class="d-flex align-items-center">
                                <i class="fas fa-clock me-2"></i>
                                <span><?php echo e($featuredTrend['read_time']); ?> min read</span>
                            </div>
                            <div class="d-flex align-items-center">
                                <i class="fas fa-calendar me-2"></i>
                                <span><?php echo e(date('M j, Y', strtotime($featuredTrend['published_date']))); ?></span>
                            </div>
                        </div>
                        <a href="#" class="btn btn-light btn-lg px-5 py-3 rounded-pill">
                            Read Full Article <i class="fas fa-arrow-right ms-2"></i>
                        </a>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="hero-image text-center">
                        <img src="<?php echo e(asset('storage/' . $featuredTrend['image'])); ?>" 
                             alt="<?php echo e($featuredTrend['title']); ?>" 
                             class="img-fluid rounded-3 shadow-lg"
                             style="max-height: 400px; object-fit: cover;">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Trend Categories Section -->
    <section class="trend-categories py-5 bg-light">
        <div class="container">
            <?php $__currentLoopData = $trendCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryKey => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="category-section mb-5">
                <div class="row">
                    <div class="col-12">
                        <div class="section-header text-center mb-5">
                            <h2 class="display-5 fw-bold text-dark"><?php echo e($category['title']); ?></h2>
                            <p class="lead text-muted"><?php echo e($category['description']); ?></p>
                        </div>
                    </div>
                </div>

                <div class="row g-4">
                    <?php $__currentLoopData = $category['trends']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="trend-card card border-0 shadow-sm h-100 overflow-hidden">
                            <div class="trend-image position-relative">
                                <img src="<?php echo e(asset('storage/' . $trend['image'])); ?>" 
                                     class="card-img-top" 
                                     alt="<?php echo e($trend['title']); ?>"
                                     style="height: 250px; object-fit: cover;">
                                
                                <?php if(isset($trend['trending_score'])): ?>
                                <div class="trending-badge position-absolute top-0 end-0 m-3">
                                    <span class="badge bg-success px-3 py-2 rounded-pill">
                                        <i class="fas fa-chart-line me-1"></i><?php echo e($trend['trending_score']); ?>%
                                    </span>
                                </div>
                                <?php endif; ?>

                                <?php if(isset($trend['season'])): ?>
                                <div class="season-badge position-absolute top-0 start-0 m-3">
                                    <span class="badge bg-primary px-3 py-2 rounded-pill">
                                        <?php echo e($trend['season']); ?>

                                    </span>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title fw-bold text-dark"><?php echo e($trend['title']); ?></h5>
                                <p class="card-text text-muted flex-grow-1"><?php echo e($trend['description']); ?></p>
                                <div class="card-actions mt-3">
                                    <a href="#" class="btn btn-outline-primary btn-sm">
                                        Learn More <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <?php if($categoryKey === 'weekly-trends'): ?>
                <div class="text-center mt-4">
                    <a href="<?php echo e(route('trends.weekly')); ?>" class="btn btn-primary btn-lg px-5 rounded-pill">
                        View All Weekly Trends <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
                <?php elseif($categoryKey === 'seasonal-forecast'): ?>
                <div class="text-center mt-4">
                    <a href="<?php echo e(route('trends.seasonal')); ?>" class="btn btn-secondary btn-lg px-5 rounded-pill">
                        View Seasonal Forecast <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
                <?php endif; ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>

    <!-- Recent Blog Posts Section -->
    <?php if($recentBlogs && $recentBlogs->count() > 0): ?>
    <section class="recent-blogs py-5">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-header text-center mb-5">
                        <h2 class="display-5 fw-bold text-dark">Latest Fashion Insights</h2>
                        <p class="lead text-muted">Stay updated with our latest blog posts and fashion insights</p>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <?php $__currentLoopData = $recentBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-3 col-md-6">
                    <div class="blog-card card border-0 shadow-sm h-100">
                        <?php if($blog->featured_image): ?>
                        <img src="<?php echo e($blog->featured_image_url); ?>" 
                             class="card-img-top" 
                             alt="<?php echo e($blog->title); ?>"
                             style="height: 200px; object-fit: cover;">
                        <?php endif; ?>
                        
                        <div class="card-body d-flex flex-column">
                            <div class="blog-meta mb-2">
                                <span class="badge bg-light text-dark"><?php echo e($blog->category ?? 'Fashion'); ?></span>
                                <span class="text-muted small ms-2">
                                    <?php echo e($blog->published_at ? $blog->published_at->format('M j, Y') : $blog->created_at->format('M j, Y')); ?>

                                </span>
                            </div>
                            <h6 class="card-title fw-bold">
                                <a href="<?php echo e(route('blogs.show', $blog)); ?>" class="text-decoration-none text-dark">
                                    <?php echo e($blog->title); ?>

                                </a>
                            </h6>
                            <p class="card-text text-muted small flex-grow-1"><?php echo e($blog->excerpt); ?></p>
                            <a href="<?php echo e(route('blogs.show', $blog)); ?>" class="btn btn-sm btn-outline-dark mt-auto">
                                Read More
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="text-center mt-5">
                <a href="<?php echo e(route('blog.index')); ?>" class="btn btn-dark btn-lg px-5 rounded-pill">
                    View All Blog Posts <i class="fas fa-arrow-right ms-2"></i>
                </a>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Quick Navigation Section -->
    <section class="quick-nav py-5 bg-dark text-white">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h3 class="text-center mb-5 fw-bold">Explore Fashion Trends</h3>
                </div>
            </div>
            <div class="row g-4 text-center">
                <div class="col-lg-3 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-chart-trending-up fa-3x mb-3 text-warning"></i>
                        <h5 class="fw-bold">Weekly Trends</h5>
                        <p class="text-muted">Latest weekly streetwear trends</p>
                        <a href="<?php echo e(route('trends.weekly')); ?>" class="btn btn-outline-warning">Explore</a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-calendar-alt fa-3x mb-3 text-info"></i>
                        <h5 class="fw-bold">Seasonal Forecast</h5>
                        <p class="text-muted">What's coming this season</p>
                        <a href="<?php echo e(route('trends.seasonal')); ?>" class="btn btn-outline-info">Explore</a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-newspaper fa-3x mb-3 text-success"></i>
                        <h5 class="fw-bold">Fashion News</h5>
                        <p class="text-muted">Industry updates and news</p>
                        <a href="<?php echo e(route('trends.news')); ?>" class="btn btn-outline-success">Explore</a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="nav-item p-4 border border-secondary rounded-3 h-100">
                        <i class="fas fa-crystal-ball fa-3x mb-3 text-danger"></i>
                        <h5 class="fw-bold">Style Predictions</h5>
                        <p class="text-muted">Future fashion forecasts</p>
                        <a href="<?php echo e(route('trends.predictions')); ?>" class="btn btn-outline-danger">Explore</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.trend-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.trend-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.1) !important;
}

.blog-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.blog-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1) !important;
}

.nav-item {
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.nav-item:hover {
    transform: translateY(-5px);
    border-color: #fff !important;
}

.featured-trend-hero {
    position: relative;
    overflow: hidden;
}

.featured-trend-hero::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.1);
    z-index: 1;
}

.featured-trend-hero .container {
    position: relative;
    z-index: 2;
}

.trending-badge .badge,
.season-badge .badge {
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\export-portfolio7\resources\views/trends/index.blade.php ENDPATH**/ ?>