

<?php $__env->startSection('title', 'Customers'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Customers</h1>
        <div class="btn-group">
            <button type="button" class="btn btn-outline-primary" onclick="exportCustomers()">
                <i class="fas fa-download"></i> Export
            </button>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.customers.index')); ?>" class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" 
                           placeholder="Search by name or email..." 
                           value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <select name="status" class="form-select">
                        <option value="all">All Status</option>
                        <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                        <option value="blocked" <?php echo e(request('status') == 'blocked' ? 'selected' : ''); ?>>Blocked</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Filter
                    </button>
                    <a href="<?php echo e(route('admin.customers.index')); ?>" class="btn btn-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <!-- Customers Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Orders</th>
                            <th>Wishlist</th>
                            <th>Joined</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($customer->id); ?></td>
                            <td>
                                <strong><?php echo e($customer->name); ?></strong>
                                <?php if($customer->is_admin): ?>
                                <span class="badge bg-primary ms-1">Admin</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($customer->email); ?></td>
                            <td>
                                <span class="badge bg-info"><?php echo e($customer->orders_count ?? 0); ?></span>
                            </td>
                            <td>
                                <span class="badge bg-secondary"><?php echo e($customer->wishlists_count ?? 0); ?></span>
                            </td>
                            <td><?php echo e($customer->created_at->format('M d, Y')); ?></td>
                            <td>
                                <?php if($customer->is_blocked ?? false): ?>
                                    <span class="badge bg-danger">Blocked</span>
                                <?php else: ?>
                                    <span class="badge bg-success">Active</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('admin.customers.show', $customer)); ?>" 
                                       class="btn btn-sm btn-primary" title="View Details">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    
                                    <?php if(!$customer->is_admin): ?>
                                        <?php if($customer->is_blocked ?? false): ?>
                                        <form action="<?php echo e(route('admin.customers.unblock', $customer)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-sm btn-success" title="Unblock">
                                                <i class="fas fa-unlock"></i>
                                            </button>
                                        </form>
                                        <?php else: ?>
                                        <form action="<?php echo e(route('admin.customers.block', $customer)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-sm btn-warning" 
                                                    title="Block" onclick="return confirm('Block this customer?')">
                                                <i class="fas fa-ban"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center py-4">
                                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                                <p>No customers found</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center mt-4">
                <div>
                    Showing <?php echo e($customers->firstItem() ?? 0); ?> to <?php echo e($customers->lastItem() ?? 0); ?> 
                    of <?php echo e($customers->total()); ?> customers
                </div>
                <?php echo e($customers->links()); ?>

            </div>
        </div>
    </div>
</div>

<script>
function exportCustomers() {
    window.location.href = '<?php echo e(route("admin.reports.export", "customers")); ?>';
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/customers/index.blade.php ENDPATH**/ ?>