<?php $__env->startSection('title', 'Australian City Style Guides - Local Fashion Inspiration'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Discover unique streetwear styles across Australian cities. From Melbourne's artistic flair to Sydney's beach culture, find your perfect local style inspiration.">
<meta name="keywords" content="australian style guide, city fashion australia, melbourne street style, sydney fashion, brisbane style, perth streetwear, adelaide fashion">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if (isset($component)) { $__componentOriginal269900abaed345884ce342681cdc99f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal269900abaed345884ce342681cdc99f6 = $attributes; } ?>
<?php $component = App\View\Components\Breadcrumb::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('breadcrumb'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Breadcrumb::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $attributes = $__attributesOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__attributesOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal269900abaed345884ce342681cdc99f6)): ?>
<?php $component = $__componentOriginal269900abaed345884ce342681cdc99f6; ?>
<?php unset($__componentOriginal269900abaed345884ce342681cdc99f6); ?>
<?php endif; ?>

<!-- Hero Section -->
<section class="style-hero py-5" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h1 class="display-4 text-white fw-bold mb-4">Australian City Style Guides</h1>
                <p class="lead text-white mb-4">Every Australian city has its unique fashion DNA. Discover how to adapt streetwear to local culture, climate, and lifestyle across Australia's major cities.</p>
                <div class="hero-stats d-flex gap-4 text-white">
                    <div class="stat-item">
                        <div class="stat-number h4 mb-0"><?php echo e(count($cities)); ?></div>
                        <small>Major Cities</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h4 mb-0">50+</div>
                        <small>Style Tips</small>
                    </div>
                    <div class="stat-item">
                        <div class="stat-number h4 mb-0">100+</div>
                        <small>Local Inspirations</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="hero-image text-center">
                    <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => 'style-guides/australia-cities-collage.jpg','alt' => 'Australian Cities Style Guide','class' => 'img-fluid rounded shadow-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- City Style Guides -->
<section class="city-guides py-5">
    <div class="container">
        <div class="row">
            <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-6 mb-5">
                    <div class="city-card h-100 bg-white rounded-lg shadow-sm overflow-hidden">
                        <div class="city-image position-relative">
                            <?php if (isset($component)) { $__componentOriginal1238c9c115275474af734e9c338ceaf4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1238c9c115275474af734e9c338ceaf4 = $attributes; } ?>
<?php $component = App\View\Components\LazyImage::resolve(['src' => ''.e($city['image']).'','alt' => ''.e($city['name']).' Style Guide','class' => 'img-fluid w-100','style' => 'height: 300px; object-fit: cover;'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('lazy-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\LazyImage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $attributes = $__attributesOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__attributesOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1238c9c115275474af734e9c338ceaf4)): ?>
<?php $component = $__componentOriginal1238c9c115275474af734e9c338ceaf4; ?>
<?php unset($__componentOriginal1238c9c115275474af734e9c338ceaf4); ?>
<?php endif; ?>
                            <div class="city-overlay position-absolute top-0 start-0 end-0 bottom-0 d-flex align-items-end p-4">
                                <div class="city-info text-white">
                                    <h3 class="mb-2"><?php echo e($city['name']); ?></h3>
                                    <p class="mb-0 opacity-90"><?php echo e($city['tagline']); ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="city-content p-4">
                            <div class="city-climate mb-3">
                                <small class="text-muted d-flex align-items-center">
                                    <i class="fas fa-thermometer-half me-2"></i>
                                    Temperate Climate
                                </small>
                            </div>
                            
                            <p class="city-description mb-3"><?php echo e($city['description']); ?></p>
                            
                            <!-- Key Style Elements -->
                            <div class="style-elements mb-4">
                                <h6 class="fw-bold mb-2">Key Style Elements:</h6>
                                <div class="row g-2">
                                    <div class="col-6">
                                        <span class="badge bg-light text-dark w-100 text-start py-2">
                                            Streetwear
                                        </span>
                                    </div>
                                    <div class="col-6">
                                        <span class="badge bg-light text-dark w-100 text-start py-2">
                                            Casual Wear
                                        </span>
                                    </div>
                                    <div class="col-6">
                                        <span class="badge bg-light text-dark w-100 text-start py-2">
                                            Urban Style
                                        </span>
                                    </div>
                                    <div class="col-6">
                                        <span class="badge bg-light text-dark w-100 text-start py-2">
                                            Local Fashion
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Color Palette -->
                            <div class="color-palette mb-4">
                                <h6 class="fw-bold mb-2">Signature Colors:</h6>
                                <div class="d-flex gap-2">
                                    <div class="color-swatch rounded-circle" 
                                         style="width: 30px; height: 30px; background-color: <?php echo e($city['color']); ?>;"
                                         title="City Color">
                                    </div>
                                    <div class="color-swatch rounded-circle" 
                                         style="width: 30px; height: 30px; background-color: #333333;"
                                         title="Dark">
                                    </div>
                                    <div class="color-swatch rounded-circle" 
                                         style="width: 30px; height: 30px; background-color: #ffffff; border: 1px solid #ddd;"
                                         title="White">
                                    </div>
                                </div>
                            </div>
                            
                            <a href="<?php echo e(route('style-guide.show', $city['slug'])); ?>" class="btn btn-primary w-100">
                                Explore <?php echo e($city['name']); ?> Style <i class="fas fa-arrow-right ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Style Tips -->
<section class="general-tips py-5 bg-light">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="text-center mb-5">
                    <h2 class="mb-4">Universal Australian Street Style Tips</h2>
                    <p class="lead">These style principles work across all Australian cities, adapted to local culture and climate.</p>
                </div>
                
                <div class="tips-grid">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="tip-card p-4 bg-white rounded shadow-sm h-100">
                                <div class="tip-icon text-primary mb-3">
                                    <i class="fas fa-sun fa-2x"></i>
                                </div>
                                <h5>Climate Adaptation</h5>
                                <p class="mb-0">Choose breathable fabrics for summer, layer smartly for unpredictable weather, and always consider UV protection in your style choices.</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="tip-card p-4 bg-white rounded shadow-sm h-100">
                                <div class="tip-icon text-primary mb-3">
                                    <i class="fas fa-users fa-2x"></i>
                                </div>
                                <h5>Cultural Respect</h5>
                                <p class="mb-0">Embrace cultural fusion respectfully, celebrate diversity through fashion, and choose brands that support inclusive values.</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="tip-card p-4 bg-white rounded shadow-sm h-100">
                                <div class="tip-icon text-primary mb-3">
                                    <i class="fas fa-leaf fa-2x"></i>
                                </div>
                                <h5>Sustainable Choices</h5>
                                <p class="mb-0">Invest in quality pieces that last, support local Australian brands, and choose eco-friendly materials when possible.</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="tip-card p-4 bg-white rounded shadow-sm h-100">
                                <div class="tip-icon text-primary mb-3">
                                    <i class="fas fa-palette fa-2x"></i>
                                </div>
                                <h5>Personal Expression</h5>
                                <p class="mb-0">Use streetwear as a canvas for self-expression, mix high and low pieces, and don't be afraid to make bold statements.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action -->
<section class="style-cta py-5">
    <div class="container text-center">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <h2 class="mb-4">Ready to Define Your City Style?</h2>
                <p class="lead mb-4">Explore our collections designed for the modern Australian lifestyle, no matter which city you call home.</p>
                <div class="cta-buttons">
                    <a href="<?php echo e(route('shop.index')); ?>" class="btn btn-primary btn-lg me-3">
                        Shop Collections <i class="fas fa-shopping-bag ms-2"></i>
                    </a>
                    <a href="<?php echo e(route('community.submit')); ?>" class="btn btn-outline-primary btn-lg">
                        Share Your Style <i class="fas fa-camera ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('styles'); ?>
<style>
    .style-hero {
        min-height: 500px;
        display: flex;
        align-items: center;
    }
    
    .city-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .city-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    }
    
    .city-overlay {
        background: linear-gradient(transparent, rgba(0,0,0,0.8));
        opacity: 0;
        transition: opacity 0.3s ease;
    }
    
    .city-card:hover .city-overlay {
        opacity: 1;
    }
    
    .color-swatch {
        border: 2px solid #fff;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        cursor: pointer;
    }
    
    .tip-card {
        border: 1px solid #e9ecef;
        transition: transform 0.3s ease;
    }
    
    .tip-card:hover {
        transform: translateY(-5px);
    }
    
    .tip-icon {
        opacity: 0.8;
    }
    
    .rounded-lg {
        border-radius: 1rem;
    }
</style>
<?php $__env->stopPush(); ?>

<!-- JSON-LD for SEO -->
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "CollectionPage",
    "name": "Australian City Style Guides",
    "description": "Comprehensive style guides for streetwear fashion across major Australian cities",
    "url": "<?php echo e(route('style-guide.index')); ?>",
    "mainEntity": {
        "@type": "ItemList",
        "itemListElement": [
            <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            {
                "@type": "Article",
                "position": <?php echo e($index + 1); ?>,
                "name": "<?php echo e($city['name']); ?> Style Guide",
                "description": "<?php echo e($city['description']); ?>",
                "url": "<?php echo e(route('style-guide.show', $city['slug'])); ?>"
            }<?php echo e(!$loop->last ? ',' : ''); ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ]
    },
    "publisher": {
        "@type": "Organization",
        "name": "Edition By Punjab",
        "url": "<?php echo e(route('home')); ?>"
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/style-guide/index.blade.php ENDPATH**/ ?>