<!-- order-tracking/index.blade.php -->


<?php $__env->startSection('title', 'Track Your Order'); ?>

<?php $__env->startSection('content'); ?>
<div class="tracking-page-premium">
    <!-- Tracking Hero -->
    <section class="tracking-hero">
        <div class="container">
            <div class="hero-content-tracking" data-aos="fade-up">
                <div class="tracking-icon-hero">
                    <i class="fas fa-shipping-fast"></i>
                </div>
                <h1 class="tracking-title">TRACK YOUR ORDER</h1>
                <p class="tracking-subtitle">Enter your details below to track your shipment</p>
            </div>
        </div>
    </section>

    <!-- Tracking Form -->
    <section class="tracking-form-section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="tracking-form-card" data-aos="zoom-in">
                        <?php if(session('error')): ?>
                            <div class="alert-premium error">
                                <i class="fas fa-exclamation-circle"></i>
                                <span><?php echo e(session('error')); ?></span>
                                <button class="alert-close" onclick="this.parentElement.style.display='none'">
                                    <i class="fas fa-times"></i>
                                </button>
                            </div>
                        <?php endif; ?>

                        <form action="<?php echo e(route('order.track')); ?>" method="POST" class="track-form-premium">
                            <?php echo csrf_field(); ?>
                            
                            <div class="form-tabs">
                                <button type="button" class="tab-btn active" data-tab="tracking">
                                    TRACKING NUMBER
                                </button>
                                <button type="button" class="tab-btn" data-tab="order">
                                    ORDER NUMBER
                                </button>
                            </div>
                            
                            <div class="tab-content active" id="tracking-tab">
                                <div class="form-group-track">
                                    <input type="text" 
                                           class="form-input-track <?php $__errorArgs = ['tracking_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="tracking_number" 
                                           name="tracking_number" 
                                           value="<?php echo e(old('tracking_number', request('tracking_number'))); ?>"
                                           placeholder=" ">
                                    <label for="tracking_number" class="form-label-track">Tracking Number</label>
                                    <?php $__errorArgs = ['tracking_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-message"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="tab-content" id="order-tab">
                                <div class="form-group-track">
                                    <input type="text" 
                                           class="form-input-track <?php $__errorArgs = ['order_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="order_number" 
                                           name="order_number" 
                                           value="<?php echo e(old('order_number')); ?>"
                                           placeholder=" ">
                                    <label for="order_number" class="form-label-track">Order Number</label>
                                    <?php $__errorArgs = ['order_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error-message"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            
                            <div class="form-group-track">
                                <input type="email" 
                                       class="form-input-track <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="email" 
                                       name="email" 
                                       value="<?php echo e(old('email')); ?>"
                                       placeholder=" "
                                       required>
                                <label for="email" class="form-label-track">Email Address *</label>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-message"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <button type="submit" class="btn-track-submit">
                                <span class="btn-text">TRACK ORDER</span>
                                <i class="fas fa-search"></i>
                            </button>
                        </form>
                        
                        <div class="track-help">
                            <p>Can't find your tracking info?</p>
                            <a href="<?php echo e(route('contact')); ?>">Contact Support</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tracking Features -->
    <section class="tracking-features">
        <div class="container">
            <div class="features-row">
                <div class="track-feature" data-aos="fade-up">
                    <div class="feature-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h4>Real-Time Updates</h4>
                    <p>Get instant updates on your package location</p>
                </div>
                
                <div class="track-feature" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-icon">
                        <i class="fas fa-bell"></i>
                    </div>
                    <h4>Email Notifications</h4>
                    <p>Receive alerts at every step of delivery</p>
                </div>
                
                <div class="track-feature" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h4>Secure Tracking</h4>
                    <p>Your tracking information is protected</p>
                </div>
            </div>
        </div>
    </section>
</div>

<?php $__env->startPush('styles'); ?>
<style>
/* Tracking Page Styles */
.tracking-page-premium {
    min-height: 100vh;
    background: #fafafa;
}

/* Tracking Hero */
.tracking-hero {
    background: linear-gradient(135deg, #000 0%, #333 100%);
    padding: 4rem 0;
    text-align: center;
}

.hero-content-tracking {
    color: white;
}

.tracking-icon-hero {
    font-size: 4rem;
    margin-bottom: 2rem;
    opacity: 0.9;
}

.tracking-title {
    font-size: 2.5rem;
    font-weight: 900;
    letter-spacing: 0.05em;
    margin-bottom: 1rem;
    font-family: 'Space Grotesk', sans-serif;
}

.tracking-subtitle {
    font-size: 1.125rem;
    opacity: 0.9;
}

/* Tracking Form Section */
.tracking-form-section {
    padding: 5rem 0;
}

.tracking-form-card {
    background: white;
    padding: 3rem;
    box-shadow: 0 10px 40px rgba(0,0,0,0.05);
}

/* Form Tabs */
.form-tabs {
    display: flex;
    margin-bottom: 2rem;
    border-bottom: 2px solid #e0e0e0;
}

.tab-btn {
    flex: 1;
    padding: 1rem;
    background: none;
    border: none;
    font-weight: 600;
    letter-spacing: 0.05em;
    color: #999;
    cursor: pointer;
    transition: all 0.3s;
    position: relative;
}

.tab-btn.active {
    color: #000;
}

.tab-btn::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    width: 100%;
    height: 2px;
    background: #000;
    transform: scaleX(0);
    transition: transform 0.3s;
}

.tab-btn.active::after {
    transform: scaleX(1);
}

.tab-content {
    display: none;
}

.tab-content.active {
    display: block;
}

/* Form Inputs */
.form-group-track {
    position: relative;
    margin-bottom: 2rem;
}

.form-input-track {
    width: 100%;
    padding: 1rem 0;
    border: none;
    border-bottom: 2px solid #e0e0e0;
    background: transparent;
    font-size: 1rem;
    transition: all 0.3s;
}

.form-input-track:focus {
    outline: none;
    border-color: #000;
}

.form-label-track {
    position: absolute;
    left: 0;
    top: 1rem;
    font-size: 1rem;
    color: #999;
    pointer-events: none;
    transition: all 0.3s;
}

.form-input-track:focus ~ .form-label-track,
.form-input-track:not(:placeholder-shown) ~ .form-label-track {
    top: -0.5rem;
    font-size: 0.75rem;
    color: #000;
}

.btn-track-submit {
    width: 100%;
    padding: 1.25rem;
    background: #000;
    color: white;
    border: none;
    font-weight: 700;
    letter-spacing: 0.05em;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 1rem;
}

.btn-track-submit:hover {
    background: #333;
    transform: translateY(-2px);
}

.track-help {
    text-align: center;
    margin-top: 2rem;
    padding-top: 2rem;
    border-top: 1px solid #e0e0e0;
}

.track-help p {
    color: #666;
    margin-bottom: 0.5rem;
}

.track-help a {
    color: #000;
    font-weight: 600;
    text-decoration: none;
}

/* Tracking Features */
.tracking-features {
    padding: 4rem 0;
    background: white;
}

.features-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
}

.track-feature {
    text-align: center;
}

.track-feature .feature-icon {
    width: 60px;
    height: 60px;
    margin: 0 auto 1.5rem;
    background: #f8f8f8;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: #000;
}

.track-feature h4 {
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.track-feature p {
    color: #666;
}

/* Responsive */
@media (max-width: 768px) {
    .tracking-title {
        font-size: 1.75rem;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Tab switching
document.querySelectorAll('.tab-btn').forEach(btn => {
    btn.addEventListener('click', function() {
        // Remove active from all tabs
        document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
        document.querySelectorAll('.tab-content').forEach(c => c.classList.remove('active'));
        
        // Add active to clicked tab
        this.classList.add('active');
        const tabId = this.dataset.tab + '-tab';
        document.getElementById(tabId).classList.add('active');
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/tracking/index.blade.php ENDPATH**/ ?>