<!-- resources/views/admin/products/index.blade.php -->


<?php $__env->startSection('title', 'Products'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Products</h1>
    <div class="d-flex gap-2">
        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#createSaleModal">
            <i class="fas fa-tags me-2"></i>Create Sale
        </button>
        <a href="<?php echo e(route('admin.products.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>Add New Product
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        <th style="width:80px;">Image</th>
                        <th>Name</th>
                        <th>Category</th>
                        <th style="width:120px;">Price</th>
                        <th>Featured</th>
                        <th>Status</th>
                        <th style="width:90px;">Views</th>
                        <th style="width:220px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <?php if($product->featured_image): ?>
                                <img src="<?php echo e(asset('storage/' . $product->featured_image)); ?>" alt="<?php echo e($product->name); ?>" width="50" height="50" class="rounded" style="object-fit:cover;">
                            <?php else: ?>
                                <div class="bg-light text-center text-muted rounded" style="width:50px;height:50px;display:flex;align-items:center;justify-content:center;">
                                    N/A
                                </div>
                            <?php endif; ?>
                        </td>

                        <td><?php echo e($product->name); ?></td>

                        <td><?php echo e(optional($product->category)->name ?? '—'); ?></td>

                        <td>
                            <?php if(!is_null($product->price)): ?>
                                $<?php echo e(number_format($product->price, 2)); ?>

                            <?php else: ?>
                                N/A
                            <?php endif; ?>
                        </td>

                        <td>
                            <span class="badge bg-<?php echo e($product->is_featured ? 'success' : 'secondary'); ?>">
                                <?php echo e($product->is_featured ? 'Yes' : 'No'); ?>

                            </span>
                        </td>

                        <td>
                            <span class="badge bg-<?php echo e($product->is_active ? 'success' : 'danger'); ?>">
                                <?php echo e($product->is_active ? 'Active' : 'Inactive'); ?>

                            </span>
                        </td>

                        <td><?php echo e($product->views ?? 0); ?></td>

                        <td>
                            <!-- public storefront view: use the shop.product route (your public route group uses shop.product) -->
                            <a href="<?php echo e(route('shop.product', $product->slug)); ?>" target="_blank" class="btn btn-sm btn-info" title="View on store">
                                <i class="fas fa-eye"></i>
                            </a>

                            <a href="<?php echo e(route('admin.products.edit', $product)); ?>" class="btn btn-sm btn-warning" title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>

                            <form action="<?php echo e(route('admin.products.destroy', $product)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this product?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center">No products found</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3 d-flex justify-content-between align-items-center">
            <div class="text-muted">
                Showing <?php echo e($products->firstItem() ?? 0); ?> - <?php echo e($products->lastItem() ?? 0); ?> of <?php echo e($products->total() ?? 0); ?>

            </div>
            <div>
                <?php echo e($products->links()); ?>

            </div>
        </div>
    </div>
</div>

<!-- Create Sale Modal -->
<div class="modal fade" id="createSaleModal" tabindex="-1" aria-labelledby="createSaleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createSaleModalLabel">
                    <i class="fas fa-tags me-2"></i>Create New Sale
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="createSaleForm" action="<?php echo e(route('admin.discounts.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <!-- Sale Details -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label for="sale_name" class="form-label">Sale Name *</label>
                            <input type="text" class="form-control" id="sale_name" name="name"
                                   placeholder="e.g., Summer Sale 2024" required>
                        </div>
                        <div class="col-md-6">
                            <label for="discount_percentage" class="form-label">Discount Percentage *</label>
                            <div class="input-group">
                                <input type="number" class="form-control" id="discount_percentage"
                                       name="discount_percentage" min="1" max="100" step="0.01" required>
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <label for="starts_at" class="form-label">Start Date *</label>
                            <input type="datetime-local" class="form-control" id="starts_at" name="starts_at" required>
                        </div>
                        <div class="col-md-6">
                            <label for="ends_at" class="form-label">End Date *</label>
                            <input type="datetime-local" class="form-control" id="ends_at" name="ends_at" required>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-12">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="3"
                                      placeholder="Optional sale description"></textarea>
                        </div>
                    </div>

                    <!-- Seasonal Settings -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h6 class="mb-0">Timer Settings</h6>
                        </div>
                        <div class="card-body">
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" id="is_seasonal" name="is_seasonal" value="1">
                                <label class="form-check-label" for="is_seasonal">
                                    Seasonal Sale (enables timer functionality)
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="show_timer" name="show_timer" value="1">
                                <label class="form-check-label" for="show_timer">
                                    Show countdown timer on homepage
                                </label>
                            </div>
                            <small class="text-muted">
                                Timer will only appear on homepage when both options are checked and sale is active.
                            </small>
                        </div>
                    </div>

                    <!-- Product Selection -->
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h6 class="mb-0">Select Products for Sale</h6>
                            <div>
                                <button type="button" class="btn btn-sm btn-outline-primary" id="selectAllProducts">
                                    Select All
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary" id="clearAllProducts">
                                    Clear All
                                </button>
                            </div>
                        </div>
                        <div class="card-body" style="max-height: 300px; overflow-y: auto;">
                            <div class="row" id="productsList">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6 mb-2">
                                    <div class="form-check">
                                        <input class="form-check-input product-checkbox" type="checkbox"
                                               id="product_<?php echo e($product->id); ?>" name="product_ids[]" value="<?php echo e($product->id); ?>">
                                        <label class="form-check-label d-flex align-items-center" for="product_<?php echo e($product->id); ?>">
                                            <?php if($product->featured_image): ?>
                                                <img src="<?php echo e(\App\Helpers\ImageHelper::getImageUrl($product->featured_image)); ?>"
                                                     alt="<?php echo e($product->name); ?>" class="me-2 rounded"
                                                     style="width: 30px; height: 30px; object-fit: cover;">
                                            <?php endif; ?>
                                            <div>
                                                <div class="fw-medium"><?php echo e($product->name); ?></div>
                                                <small class="text-muted">$<?php echo e(number_format($product->price, 2)); ?></small>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>

                    <!-- Hidden fields for form processing -->
                    <input type="hidden" name="discount_type" value="products">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success" id="createSaleBtn">
                        <i class="fas fa-tags me-2"></i>Create Sale
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Set default start date to now
    const now = new Date();
    now.setMinutes(now.getMinutes() - now.getTimezoneOffset());
    document.getElementById('starts_at').value = now.toISOString().slice(0, 16);

    // Set default end date to 7 days from now
    const endDate = new Date(now.getTime() + 7 * 24 * 60 * 60 * 1000);
    document.getElementById('ends_at').value = endDate.toISOString().slice(0, 16);

    // Select All functionality
    document.getElementById('selectAllProducts').addEventListener('click', function() {
        document.querySelectorAll('.product-checkbox').forEach(checkbox => {
            checkbox.checked = true;
        });
    });

    // Clear All functionality
    document.getElementById('clearAllProducts').addEventListener('click', function() {
        document.querySelectorAll('.product-checkbox').forEach(checkbox => {
            checkbox.checked = false;
        });
    });

    // Form validation
    document.getElementById('createSaleForm').addEventListener('submit', function(e) {
        const selectedProducts = document.querySelectorAll('.product-checkbox:checked');
        if (selectedProducts.length === 0) {
            e.preventDefault();
            alert('Please select at least one product for the sale.');
            return false;
        }

        // Show loading state
        const submitBtn = document.getElementById('createSaleBtn');
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Creating Sale...';
    });

    // Enable/disable timer checkbox based on seasonal checkbox
    document.getElementById('is_seasonal').addEventListener('change', function() {
        const showTimerCheckbox = document.getElementById('show_timer');
        if (!this.checked) {
            showTimerCheckbox.checked = false;
            showTimerCheckbox.disabled = true;
        } else {
            showTimerCheckbox.disabled = false;
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/admin/products/index.blade.php ENDPATH**/ ?>