<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title'); ?> - Admin Dashboard</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo e(\App\Helpers\ImageHelper::getFaviconUrl()); ?>">
    <link rel="shortcut icon" type="image/png" href="<?php echo e(\App\Helpers\ImageHelper::getFaviconUrl()); ?>">

    <!-- Bootstrap & FontAwesome -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        /* Sidebar base */
        .sidebar,
        .sb-sidenav {
            min-height: 100vh;
            background: #0f1724; /* darker */
            color: #e6eef8;
        }

        /* Sidenav internal structure */
        .sb-sidenav .sb-sidenav-menu {
            padding: 1rem;
        }

        .sb-sidenav-menu-heading {
            font-size: 0.75rem;
            text-transform: uppercase;
            color: rgba(255,255,255,0.55);
            padding: 0.75rem 1rem;
            letter-spacing: .08em;
        }

        .sb-sidenav .nav-link {
            color: rgba(255,255,255,0.85);
            display: flex;
            align-items: center;
            gap: .75rem;
            padding: .6rem 1rem;
            border-left: 3px solid transparent;
            transition: all .18s;
            text-decoration: none;
        }

        .sb-sidenav .nav-link i {
            width: 20px;
            text-align: center;
            font-size: 0.95rem;
        }

        .sb-sidenav .nav-link:hover,
        .sb-sidenav .nav-link.active {
            background: rgba(255,255,255,0.04);
            color: #ffffff;
            border-left-color: #3b82f6; /* blue accent */
        }

        .sb-sidenav .badge {
            font-size: .70rem;
            padding: .25rem .5rem;
        }

        /* Content wrapper */
        .content-wrapper {
            background: #f8f9fa;
            min-height: 100vh;
        }

        /* Small helpers */
        .logo-heading {
            padding: 1.25rem 1rem;
            text-align: center;
            color: #fff;
            border-bottom: 1px solid rgba(255,255,255,0.03);
        }

        .logo-heading h4 {
            margin: 0;
            font-size: 1.05rem;
            font-weight: 600;
        }

        /* Responsive adjustments */
        @media (max-width: 767.98px) {
            .sidebar {
                position: relative;
                width: 100%;
            }
        }

        <?php echo $__env->yieldPushContent('admin-styles'); ?>
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <div class="d-flex">
        <!-- Sidebar (updated) -->
        <nav class="sidebar sb-sidenav accordion sb-sidenav-dark col-md-3 col-lg-2 d-md-block" id="sidenavAccordion">
            <div class="position-sticky pt-3">
                <div class="logo-heading">
                    <h4>Admin Panel</h4>
                </div>

                <div class="sb-sidenav-menu">
                    <div class="nav">
                        <div class="sb-sidenav-menu-heading">Core</div>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="fas fa-tachometer-alt"></i>
                            Dashboard
                        </a>

                        <div class="sb-sidenav-menu-heading">Sales</div>

                        <!-- Orders Management - Priority Section -->
                        <a class="nav-link <?php echo e(request()->routeIs('admin.orders.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.orders.index')); ?>">
                            <i class="fas fa-shopping-cart"></i>
                            Orders
                            <?php
                                $pendingOrders = \App\Models\Order::where('status', 'pending')->count();
                            ?>
                            <?php if($pendingOrders > 0): ?>
                                <span class="badge bg-danger ms-auto"><?php echo e($pendingOrders); ?></span>
                            <?php endif; ?>
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.customers.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.customers.index')); ?>">
                            <i class="fas fa-users"></i>
                            Customers
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.coupons.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.coupons.index')); ?>">
                            <i class="fas fa-ticket-alt"></i>
                            Coupons
                        </a>

                        <!-- Added Shipping & Tax section after Coupons -->
                        <div class="sb-sidenav-menu-heading">Shipping & Tax</div>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.shipping-zones.*') ? 'active' : ''); ?>"
                           href="<?php echo e(route('admin.shipping-zones.index')); ?>">
                            <i class="fas fa-truck"></i>
                            Shipping Zones
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.tax-rates.*') ? 'active' : ''); ?>"
                           href="<?php echo e(route('admin.tax-rates.index')); ?>">
                            <i class="fas fa-percentage"></i>
                            Tax Rates
                        </a>
                        <!-- End Shipping & Tax -->

                        <div class="sb-sidenav-menu-heading">Catalog</div>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.products.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.products.index')); ?>">
                            <i class="fas fa-box"></i>
                            Products
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.categories.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.categories.index')); ?>">
                            <i class="fas fa-tags"></i>
                            Categories
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.discounts.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.discounts.index')); ?>">
                            <i class="fas fa-percentage"></i>
                            Discounts
                        </a>

                        <!-- Home Page Management Section -->
                        <div class="sb-sidenav-menu-heading">Home Page</div>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.banners.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.banners.index')); ?>">
                            <i class="fas fa-images"></i>
                            <span>Banner Management</span>
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.instagram.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.instagram.index')); ?>">
                            <i class="fab fa-instagram"></i>
                            <span>Instagram Feed</span>
                        </a>

                        <div class="sb-sidenav-menu-heading">Content</div>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.inquiries.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.inquiries.index')); ?>">
                            <i class="fas fa-envelope"></i>
                            Inquiries
                            <?php
                                $newInquiries = \App\Models\Inquiry::where('status', 'new')->count();
                            ?>
                            <?php if($newInquiries > 0): ?>
                                <span class="badge bg-warning ms-auto"><?php echo e($newInquiries); ?></span>
                            <?php endif; ?>
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.testimonials.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.testimonials.index')); ?>">
                            <i class="fas fa-comment"></i>
                            Testimonials
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.legal-pages.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.legal-pages.index')); ?>">
                            <i class="fas fa-file-contract"></i>
                            Legal Pages
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.blogs.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.blogs.index')); ?>">
                            <i class="fas fa-blog"></i>
                            Blog Management
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.community.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.community.index')); ?>">
                            <i class="fas fa-users"></i>
                            Community Posts
                            <?php
                                $pendingPosts = \App\Models\CommunityPost::where('status', 'pending')->count();
                            ?>
                            <?php if($pendingPosts > 0): ?>
                                <span class="badge bg-warning ms-auto"><?php echo e($pendingPosts); ?></span>
                            <?php endif; ?>
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.community-pages.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.community-pages.index')); ?>">
                            <i class="fas fa-file-alt"></i>
                            Community Pages
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.style-guides.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.style-guides.index')); ?>">
                            <i class="fas fa-map-marked-alt"></i>
                            Style Guides
                        </a>

                        <div class="sb-sidenav-menu-heading">Trends & News</div>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.trends.index') ? 'active' : ''); ?>" href="<?php echo e(route('admin.trends.index')); ?>">
                            <i class="fas fa-chart-trending-up"></i>
                            Trends Dashboard
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.trends.weekly*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.trends.weekly')); ?>">
                            <i class="fas fa-calendar-week"></i>
                            Weekly Trends
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.trends.news*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.trends.news')); ?>">
                            <i class="fas fa-newspaper"></i>
                            Fashion News
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.trends.seasonal*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.trends.seasonal')); ?>">
                            <i class="fas fa-calendar-alt"></i>
                            Seasonal Forecasts
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.trends.predictions*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.trends.predictions')); ?>">
                            <i class="fas fa-crystal-ball"></i>
                            Style Predictions
                        </a>

                        <div class="sb-sidenav-menu-heading">Reports & Settings</div>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.reports.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.reports.index')); ?>">
                            <i class="fas fa-chart-bar"></i>
                            Reports
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.company.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.company.edit')); ?>">
                            <i class="fas fa-building"></i>
                            Company Info
                        </a>

                        <a class="nav-link <?php echo e(request()->routeIs('admin.settings.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.settings.index')); ?>">
                            <i class="fas fa-cog"></i>
                            Settings
                        </a>

                        <!-- Divider -->
                        <div style="height: 1px; background: rgba(255,255,255,0.03); margin: .75rem 0;"></div>

                        <a class="nav-link" href="<?php echo e(route('home')); ?>" target="_blank">
                            <i class="fas fa-external-link-alt"></i>
                            View Website
                        </a>

                        <form method="POST" action="<?php echo e(route('logout')); ?>" class="px-3 mt-2">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-link nav-link text-start p-0 w-100" style="color: rgba(255,255,255,0.9);">
                                <i class="fas fa-sign-out-alt"></i> Logout
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main class="content-wrapper col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="py-4">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
    </div>

    <!-- Bootstrap JS bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\export-portfolio8\resources\views/admin/layouts/admin.blade.php ENDPATH**/ ?>