<?php $__env->startSection('title', 'Verify Email'); ?>

<?php $__env->startSection('content'); ?>
<div class="auth-container">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="auth-card" data-aos="zoom-in">
                    <div class="auth-header">
                        <div class="auth-icon">
                            <i class="fas fa-envelope-open-text"></i>
                        </div>
                        <h2 class="auth-title">Verify Your Email</h2>
                        <p class="auth-subtitle">Please check your inbox</p>
                    </div>

                    <div class="auth-body">
                        <div class="alert alert-info mb-4">
                            <i class="fas fa-info-circle"></i>
                            Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn't receive the email, we will gladly send you another.
                        </div>

                        <?php if(session('status') == 'verification-link-sent'): ?>
                            <div class="alert alert-success mb-4">
                                <i class="fas fa-check-circle"></i>
                                A new verification link has been sent to the email address you provided during registration.
                            </div>
                        <?php endif; ?>

                        <div class="d-flex justify-content-between align-items-center">
                            <form method="POST" action="<?php echo e(route('verification.send')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-paper-plane"></i>
                                    Resend Verification Email
                                </button>
                            </form>

                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-link text-muted">
                                    Log Out
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="auth-footer text-center mt-4">
                    <p class="text-muted">
                        <i class="fas fa-clock"></i>
                        Verification links expire after 60 minutes
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.auth-container {
    min-height: 80vh;
    display: flex;
    align-items: center;
    padding: 3rem 0;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
}

.auth-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.1);
    overflow: hidden;
}

.auth-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 2rem;
    text-align: center;
}

.auth-icon {
    width: 80px;
    height: 80px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 1rem;
    font-size: 2rem;
}

.auth-title {
    font-size: 1.75rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.auth-subtitle {
    font-size: 1rem;
    opacity: 0.9;
}

.auth-body {
    padding: 2rem;
}

.alert {
    border-radius: 10px;
    padding: 1rem;
    border: none;
}

.alert-info {
    background: #e3f2fd;
    color: #1565c0;
}

.alert-success {
    background: #e8f5e9;
    color: #2e7d32;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    padding: 0.75rem 1.5rem;
    border-radius: 25px;
    font-weight: 600;
    transition: transform 0.3s;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(102,126,234,0.4);
}

.btn-link {
    color: #6c757d;
    text-decoration: none;
    font-weight: 500;
}

.btn-link:hover {
    color: #495057;
}

.auth-footer {
    animation: fadeInUp 0.6s ease-out 0.3s both;
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/punjdnwx/public_html/resources/views/auth/verify-email.blade.php ENDPATH**/ ?>