<?php

namespace App\Http\Controllers;

use App\Models\Area;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class AreaController extends Controller
{
    


     
    public function load_areas(Request $request)
    {
        // $users = User::all();

        // return view('admin.users', compact('users'));

        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $query = DB::table('areas')
        ->leftJoin('cities', 'areas.city_id', '=', 'cities.id')
        ->select('areas.*',
            'cities.city_name as city_name');

        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('areas.area_name', 'like', '%' . $search . '%');
        }



        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $users = $query->get();

   

        $all_data = [];
        foreach ($users as $user) {

           

            $btn = '<td class="text-right">';
            if (Auth::user()->can('update_user')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_user')) {
                $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }
            $btn .= '</td>';


            $all_data[] = [
                'id'            => $user->id,
                'area_name'          => $user->area_name,
                'city_name'          => $user->city_name,

                'btn'           => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ];

        return response()->json($data);


    }

    public function insert_area(Request $request)
    {
        $area = Area::where('area_name', $request->input('area_name'))->exists();

        if($area){

            return response()->json([
                'status'=> "area_Exist",
            ]);
            
        }
        else{

            

            $data = new Area();
            $data->area_name         = $request->input('area_name');
            $data->city_id         = $request->input('city_id');

            $data->created_by   = Auth::id();

            $data->save();

            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function edit_area($id)
    {
       $data = DB::table('areas')
        ->leftJoin('cities', 'areas.city_id', '=', 'cities.id')
        ->select(
            'areas.*',
            'cities.city_name'
        )
        ->where('areas.id', $id)
        ->first();
         
        return response()->json([
            'status' => 200,
            'data' => $data, 
        ]);
    }

    public function update_area(Request $request)
    {
        $area_name =  Area::where('area_name', $request->input('area_name'))
        ->where('id', '!=', $request->input('area_id'))->exists();

        if($area_name){

            return response()->json([
                'status'=> "area_Exist",
            ]);
            
        }else{

            $data                       = Area::findOrFail($request->input('area_id'));
            $data->area_name            = $request->input('area_name');
            $data->city_id              = $request->input('city_id');
            $data->updated_by           = Auth::id();
            $data->save();
            
            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function delete_area($id)
    {
        $data = Area::find($id);

        $data->delete();

        return response()->json([
            'status'=>200
        ]);
    }


    public function get_areas(Request $request)
    {
        $cityId = $request->city_id;
        $areas = Area::where('city_id', $cityId)->get(); // filter by city
        return response()->json($areas);
    }



}
