<?php

namespace App\Http\Controllers;

use App\Models\Bank;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class BankController extends Controller
{
    

    public function load_banks(Request $request)
    {
        // $users = User::all();

        // return view('admin.users', compact('users'));

        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $query = DB::table('banks');

        // Role-based filter
        if (!Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            $query->where('banks.created_by', Auth::id());
        }


        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('banks.bank_name', 'like', '%' . $search . '%');
        }



        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $users = $query->get();

   

        $all_data = [];
        foreach ($users as $user) {

           

            $btn = '<td class="text-right">';

            // View button
            // $btn .= '<a href="' . route("customer_ledger", $user->id) . '" 
            // class="btn btn-success btn-icon" data-toggle="tooltip" title="View" style="padding: 6px 10px;"><i class="fa-duotone fa-memo" style="margin-right: 3px"></i></a>';

            // if (Auth::user()->can('update_bank')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            // }
            // if (Auth::user()->can('delete_bank')) {
                $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="margin-right: 3px"><i class="fa-duotone fa-trash-xmark"></i></button>';
            // }
            // Withdraw button
            $btn .= '<button id="withdraw_btn" data-wid="'.$user->id.'" class="btn btn-warning btn-icon" data-toggle="tooltip" title="Withdraw" style="padding: 6px 10px;"><i class="fa-duotone fa-money-bill-transfer"></i></button>';
            $btn .= '</td>';


            $all_data[] = [
                'id'                        => $user->id,
                'bank_name'                      => $user->bank_name,
                'account_title'                => $user->account_title,
                'account_number'           => $user->account_number,

                'branch'                     => $user->branch,
                'bank_balance'                 => $user->bank_balance,
                'btn'                       => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ];

        return response()->json($data);


    }

    public function insert_bank(Request $request)
    {
        $bank = Bank::where('bank_name', $request->input('bank_name'))->exists();

        if($bank){

            return response()->json([
                'status'=> "bank_Exist",
            ]);
            
        }else{

           

            $data = new Bank();
            $data->bank_name       = $request->input('bank_name');
            $data->account_title   = $request->input('account_title');
            $data->account_number  = $request->input('account_number');
            $data->branch          = $request->input('branch');
            $data->bank_balance    = $request->input('bank_balance');
            $data->created_by      = Auth::id();

            $data->save();

            return response()->json([
                'status'=>200
            ]);

        }
    }

   
    public function edit_bank($id)
    {
        // Retrieve the sale with customer details
        $data = Bank::findOrFail($id);

         
        return response()->json([
            'status' => 200,
            'data' => $data, 
        ]);
    }

    public function update_bank(Request $request)
    {
        $bank =  Bank::where('bank_name', $request->input('bank_name'))
        ->where('id', '!=', $request->input('bank_id'))->exists();

        if($bank){

            return response()->json([
                'status'=> "bank_Exist",
            ]);
            
        }else{

            $user = Bank::findOrFail($request->input('bank_id'));

            $user->bank_name            = $request->input('bank_name');
            $user->account_title        = $request->input('account_title');
            $user->account_number       = $request->input('account_number');
            $user->branch               = $request->input('branch');
            $user->bank_balance         = $request->input('bank_balance');

            $user->updated_by           = Auth::id();



            $user->save();
            

            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function delete_bank($id)
    {
        $data = Bank::find($id);

        $data->delete();

        return response()->json([
            'status'=>200
        ]);
    }

    public function withdraw_bank(Request $request, $id)
    {
        $bank = Bank::findOrFail($id);
        $amount = $request->input('amount');

        // Check if bank has sufficient balance
        if ($bank->bank_balance < $amount) {
            return response()->json([
                'status' => 400,
                'message' => 'Insufficient balance in the bank account'
            ]);
        }

        // Update bank balance
        $bank->bank_balance -= $amount;
        $bank->save();

        // You might want to create a transaction record here
        // For now, just return success

        return response()->json([
            'status' => 200,
            'message' => 'Amount withdrawn successfully'
        ]);
    }


    public function get_banks()
    {
        // Admins get all customers
        $data = Bank::all();

        return response()->json($data);
    }


}
