<?php

namespace App\Http\Controllers;

use App\Models\Bom;
use App\Models\BomDetail;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class BomController extends Controller
{
    

    public function load_bom(Request $request)
    {
        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

    

        $query = DB::table('boms');



        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('created_by', [$start_date, $end_date]);
        }

     
        if ($search = $request->input('search')) { 
            $query->where(function ($q) use ($search) {
                $q->where('boms.bom_name', 'like', '%' . $search . '%'); // Adjust date format if needed
            });
        }
        $type = $request->input('type');
        if (isset($type)) {
            $query->where('boms.status', '=', $type);
        }

        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $purchases = $query->get();

        $all_data = [];

        
        foreach ($purchases as $data) {

           

            $btn = '<td >';
            // if (Auth::user()->can('view_boms')) {
            //     $btn .= '<button id="view_btn" data-vid="'.$data->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="View" style="margin-right: 3px"><i class="fa-duotone fa-arrows-to-eye"></i></button>';
            // }

            if (Auth::user()->can('update_bom')) {
                $btn .= '<button id="edit_btn" data-eid="'.$data->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_bom')) {
                $btn .= '<button id="delete_btn" data-did="'.$data->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }
            $btn .= '</td>';

            $all_data[] = [
                'id'            => $data->id,
                'bom_name'      => $data->bom_name,
                'btn'           => $btn
            ];
        };

      

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data
        ];

        return response()->json($data);
    }



    public function insert_bom(Request $request)
    {

        $bom = new Bom();
        $bom->date                 = Carbon::parse($request->input('date'))->format('Y-m-d');
        $bom->bom_name          = $request->input('bom_name'); 
        $bom->grand_total          = $request->input('grand_total'); 

        $bom->created_by          = Auth::id();
        $bom->save();

        // Get the last inserted BOM ID
        $bom_id = $bom->id;
        // Extract data from the request
        $pro_ids    = $request->input('pro_id'); 
        $pro_qty    = $request->input('pro_qty'); 
        $pro_unit    = $request->input('pro_unit'); 
        $pro_price    = $request->input('pro_price'); 
        $total    = $request->input('total'); 



        // Loop through the data and save each entry
        foreach ($pro_ids as $index => $pro_id) {

            $product_stock                      = new BomDetail();
            $product_stock->bom_id             = $bom_id;
            $product_stock->pro_id              = $pro_id; 
            $product_stock->quantity             = $pro_qty[$index]; 
            $product_stock->pro_unit             = $pro_unit[$index]; 
            $product_stock->pro_price             = $pro_price[$index]; 
            $product_stock->total             = $total[$index]; 
            $product_stock->save();

           
        }

        
        return response()->json([
            'status'=>200
        ]);

        
    }


    public function edit_bom($id)
    {
        // Retrieve the bom with supplier and product details
        $data = DB::table('boms')
            ->where('boms.id', $id)
            ->first();
    
        // Retrieve BOM details
        $bom_details = DB::table('bom_details')
            ->join('products', 'bom_details.pro_id', '=', 'products.id')
            ->select(
                'bom_details.*',
                'products.pro_name'
            )
            ->where('bom_details.bom_id', '=', $id)
            ->get();
    
        // Ensure data exists before returning
        if (!$data) {
            return response()->json([
                'status' => 404,
                'message' => 'BOM not found.',
            ]);
        }
    
        return response()->json([
            'status' => 200,
            'data' => $data,
            'bom_details' => $bom_details,
        ]);
    }
    

    public function update_bom(Request $request)
    {
        // Find the bom record by ID
        $bom = Bom::find($request->input('bom_id'));

        if (!$bom) {
            return response()->json(['status' => 404, 'message' => 'BOM not found.']);
        }

        // Update the main BOM record 
        $bom->date         = Carbon::parse($request->input('date'))->format('Y-m-d');
        $bom->bom_name          = $request->input('bom_name');
        $bom->grand_total          = $request->input('grand_total'); 
        $bom->updated_by          = Auth::id();

        $bom->save();

        // Delete old BOM details for this BOM
        BomDetail::where('bom_id', $bom->id)->delete();


        // Reinsert the sale details
        $pro_ids = $request->input('pro_id'); 
        $pro_qty = $request->input('pro_qty');
        $pro_unit    = $request->input('pro_unit'); 
        $pro_price    = $request->input('pro_price'); 
        $total    = $request->input('total');  

        foreach ($pro_ids as $index => $pro_id) {
            $product_stock = new BomDetail();
            $product_stock->bom_id     = $bom->id;
            $product_stock->pro_id      = $pro_id; 
            $product_stock->quantity    = $pro_qty[$index]; 
            $product_stock->pro_unit             = $pro_unit[$index]; 
            $product_stock->pro_price             = $pro_price[$index]; 
            $product_stock->total             = $total[$index]; 
            $product_stock->save();
 
        }

     

        return response()->json(['status' => 200, 'message' => 'Sale updated successfully.']);
    }

    
    public function view_purchase($id)
    {
        $purchase = DB::table('purchases')
            ->leftJoin('suppliers', 'purchases.supplier_id', '=', 'suppliers.id')
            ->select(
                '*', 'suppliers.sup_name', // Select specific fields
                'purchases.id as id'
            )
            ->where('purchases.id', $id)
            ->first();

        if (!$purchase) {
            return response()->json([
                'status' => 404,
                'message' => 'Purchase not found'
            ], 404);
        }

        $all_suppliers = DB::table('suppliers')->select('id', 'sup_name')->get();

        $purchase_details = DB::table('purchase_details')
        ->select('*')->where('purchase_id', '=', $id)
        ->get();

        $products = [];

        foreach($purchase_details AS $index => $pros){

            $pro = DB::table('products')->select('*')
            ->where('id', '=', $pros->pro_id)->first();
            
            $products[] = [
                'no'        => $index+1,
                'pro_id'     => $pro->id,
                'pro_name'   => $pro->pro_name,
                'purchase_price' => $pros->single_price,
                'pro_qty'    => $pros->pro_qty,
                'total_amount'=> $pros->total_amount,
            ];
        }

        return response()->json([
            'status' => 200,
            'purchase' => $purchase,
            'products' => $products,
            'all_suppliers' => $all_suppliers,
        ]);
    }

    public function delete_bom($id)
    {
        $data = Bom::find($id);

        if (!$data) {
            return response()->json([
                'status' => 404,
                'message' => 'BOM not found.'
            ]);
        }

        // پہلے BOMDetails delete کرو
        $data->bomDetails()->delete(); 
        // پھر BOM delete کرو
        $data->delete();


        return response()->json([
            'status' => 200,
            'message' => 'Bom and its details deleted successfully.'
        ]);
    }

    public function get_bom()
    { 
            // Admins get all customers
            $bom = Bom::all(); 

        return response()->json($bom);
    }

    // public function get_bom_price($id)
    // {
    //     $bom = DB::table('boms')
    //         ->leftJoin('bom_details', 'boms.id', '=', 'bom_details.bom_id')
    //         ->leftJoin('purchase_details', 'bom_details.pro_id', '=', 'purchase_details.pro_id')
    //         ->select(
    //             'boms.id',
    //             'boms.bom_name',
    //             'boms.date',
    //             DB::raw('IFNULL(SUM(purchase_details.purchase_price * bom_details.quantity), 0) as total_price')
    //         )
    //         ->where('boms.id', $id)
    //         ->groupBy('boms.id', 'boms.bom_name', 'boms.date')
    //         ->first(); // single record only

    //     return response()->json($bom);
    // }

    public function get_bom_price($id)
    {
        $bom = DB::table('boms')
            ->select(
                'boms.id',
                'boms.bom_name',
                'boms.date',
                'boms.grand_total as total_price' // 👈 directly boms table ka column
            )
            ->where('boms.id', $id)
            ->first(); // single record only

        return response()->json($bom);
    }






}
