<?php

namespace App\Http\Controllers;

use App\Models\CompanyInvestment;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class CompanyInvestmentController extends Controller
{
    public function load_company_investments(Request $request)
    {
        // $users = User::all();

        // return view('admin.users', compact('users'));

        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $query = DB::table('company_investments')
        ->leftJoin('users', 'company_investments.created_by', '=', 'users.id')
        ->select(
            'company_investments.*',
            'users.name as created_by'
        );

        // Role-based filter
        if (!Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            $query->where('company_investments.created_by', Auth::id());
        }


        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('company_investments.created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('users.name', 'like', '%' . $search . '%');
        }



        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $users = $query->get();

   

        $all_data = [];
        foreach ($users as $user) {

           

            $btn = '<td class="text-right">';

            // View button
            // $btn .= '<a href="' . route("customer_ledger", $user->id) . '" 
            // class="btn btn-success btn-icon" data-toggle="tooltip" title="View" style="padding: 6px 10px;"><i class="fa-duotone fa-memo" style="margin-right: 3px"></i></a>';

            if (Auth::user()->can('update_company_investment')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_company_investment')) {
                $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }
            $btn .= '</td>';

            

            $all_data[] = [
                'id'                        => $user->id,
                'created_by'                      => $user->created_by,
                'invested_amount'           => $user->invested_amount,
                'payment_method'                     => $user->payment_type,
                'date'                 => $user->date,
                // 'btn'                       => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ];

        return response()->json($data);


    }

    public function insert_company_investment(Request $request)
    {
        

        $data = new CompanyInvestment();
        $data->payment_type             = $request->input('payment_type');
        $data->bank_id                  = $request->input('bank_id');
        $data->invested_amount          = $request->input('invested_amount');
        $data->remaining_amount          = $request->input('invested_amount'); 
        $data->date                     = Carbon::parse($request->input('date'))->format('Y-m-d');
        $data->created_by       = Auth::id();
        $data->save();

        // investor paymrnt add in to company balanve
        if ($request->payment_type === "Cash") {
            // hand_cash column
            DB::table('hand_cashes')->increment('cash_amount', $request->invested_amount);

            DB::table('transactions')->insert([
                'payment_type' => 'Cash',
                'amount' => $request->invested_amount,
                'transaction_type' => 'deposit',
                'source_type' => 'Company Investment',
                'source_id' => $data->id,
                'description' => 'Company Investment Made',
                'created_at' => now(),
            ]);

        } elseif ($request->payment_type === "Bank") {

            DB::table('banks')->where('id', $request->bank_id)
            ->increment('bank_balance', $request->invested_amount);

            DB::table('transactions')->insert([
                'payment_type' => 'Bank',
                'bank_id' => $request->bank_id,
                'amount' => $request->invested_amount,
                'transaction_type' => 'deposit',
                'source_type' => 'Company Investment',
                'source_id' => $data->id,
                'description' => 'Company Investment Made',
                'created_at' => now(),
            ]);
        }

         

        return response()->json([
            'status'=>200
        ]);

    }

    public function edit_company_investment($id)
    {

        $data = DB::table('company_investments')
        ->leftJoin('users', 'company_investments.created_by', '=', 'users.id')
        ->leftJoin('banks', 'company_investments.bank_id', '=', 'banks.id')

        ->select(
            'company_investments.*',
            'users.name as user_name',
            'banks.bank_name'
        )
        ->where('company_investments.id', $id)
        ->first();

         
        return response()->json([
            'status' => 200,
            'data' => $data, 
        ]);
    }

    public function update_company_investment(Request $request)
    {
        

        $user = CompanyInvestment::findOrFail($request->input('investment_id'));
        $user->payment_type                 = $request->input('payment_type');
        $user->bank_id                      = $request->input('bank_id');
        $user->invested_amount              += $request->input('new_add_amount');
        $user->updated_by                   = Auth::id();

        // investor paymrnt add in to company balanve
        if ($request->payment_type === "Cash") {
            // hand_cash column
            DB::table('hand_cashes')->increment('cash_amount', $request->new_add_amount);

        } elseif ($request->payment_type === "Bank") {

            DB::table('banks')->where('id', $request->bank_id)
            ->increment('bank_balance', $request->new_add_amount);
        }


        $user->save();
        

        return response()->json([
            'status'=>200
        ]);

    }

    public function delete_company_investment($id)
    {
        $data = CompanyInvestment::find($id);

        $data->delete();

        return response()->json([
            'status'=>200
        ]);
    }


    public function get_company_investment()
    {
        if (Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            // Admins get all investment
            $investment = CompanyInvestment::all();
        } else {
            // Other users get only their own created investment
            $investment = CompanyInvestment::where('created_by', Auth::id())->get();
        }

        return response()->json($investment);
    }


    public function total_company_invested_amount()
    {
        $invested_amount = DB::table('company_investments')
        ->whereNotNull('invested_amount')
        ->sum('invested_amount');

        return response()->json([
            'invested_amount' => 'Rs. ' . number_format($invested_amount, 2)
        ]);
    }




}
