<?php

namespace App\Http\Controllers;

use App\Models\ContracterLedger;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ContracterController extends Controller
{
    
    
    public function load_contracter_order(Request $request)
    {
        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('enddate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");


       $query = DB::table('contracter_ledgers')
        ->leftJoin('products', 'contracter_ledgers.pro_id', '=', 'products.id')
        ->leftJoin('contractors', 'contracter_ledgers.contractor_id', '=', 'contractors.id')
        ->leftJoin('repair_orders', 'contracter_ledgers.repair_order_id', '=', 'repair_orders.id')
        ->leftJoin('productions', 'contracter_ledgers.production_id', '=', 'productions.id')

        ->select(
            'contracter_ledgers.*',
            'products.pro_name',
            'contractors.name as contracter_name',
            // Use COALESCE to get pro_qty from either contracter_ledgers, repair_orders, or productions
            DB::raw('COALESCE(contracter_ledgers.pro_qty, repair_orders.pro_qty, productions.pro_qty, 0) as pro_qty')

        );

        // Role-based filter
        if (!Auth::user()->hasRole(['Admin', 'Super Admin', 'Store man', 'Production Manager'])) {
            $query->where('contracter_ledgers.created_by', Auth::id());
        }


        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('contracter_ledgers.date', [$start_date, $end_date]);
        }


        if ($search = $request->input('search')) {
            $query->where(function ($q) use ($search) {
                $q->where('contractors.name', 'like', '%' . $search . '%')
                  ->orWhere('products.pro_name', 'like', '%' . $search . '%');
            });
        }
        $type = $request->input('type');
        if (isset($type) && $type !== '') {
            $query->where('contracter_ledgers.payment_status', '=', $type);
        }

        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        if (!empty($order_by)) {
            $query->orderBy($order_by, $dir ?? 'asc');
        } else {
            $query->orderBy('contracter_ledgers.id', 'desc');
        }
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $purchases = $query->get();

        $all_data = [];


        foreach ($purchases as $data) {



            $btn = '<td >';

            // Only show edit button if payment status is not Paid
            if ($data->payment_status !== 'Paid') {
                $btn .= '<button id="edit_btn" data-eid="'.$data->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Pay Labour Cost" style="margin-right: 3px"><i class="fa-duotone fa-money-bill"></i></button>';
            }

            $btn .= '</td>';

            // Status badge for payment status
            if ($data->payment_status == "Pending") {
                $payment_status = '<div class="label label-table label-warning" style="width:100%; max-width:130px;">Pending</div>';
            } else if ($data->payment_status == "Paid") {
                $payment_status = '<div class="label label-table label-success" style="width:100%; max-width:130px;">Paid</div>';
            } else {
                $payment_status = '<div class="label label-table label-info" style="width:100%; max-width:130px;">'.$data->payment_status.'</div>';
            }

            // Status badge for repair status
            if ($data->status == "Completed") {
                $status = '<div class="label label-table label-success" style="width:100%; max-width:130px;">Completed</div>';
            } else {
                $status = '<div class="label label-table label-warning" style="width:100%; max-width:130px;">'.$data->status.'</div>';
            }

            $all_data[] = [
                'id'                => $data->id,
                'contracter_name'   => $data->contracter_name ?? '',
                'pro_name'          => $data->pro_name ?? '',
                'batch_number'      => $data->batch_number ?? '',
                'price'             => number_format($data->price ?? 0, 2),
                'pro_qty'           => $data->pro_qty ?? 0,
                'labour_cost'       => number_format($data->labour_cost ?? 0, 2),
                'material_cost'     => number_format($data->material_cost ?? 0, 2),
                'total_price'       => number_format($data->total_price ?? 0, 2),
                'receive_amount'    => number_format($data->receive_amount ?? 0, 2),
                'date'              => $data->date ? Carbon::parse($data->date)->format('d-m-Y') : '',
                'status'            => $status,
                'payment_type'      => $data->Payment_type ?? 'Cash',
                'payment_status'    => $payment_status,


                'btn'               => $btn
            ];
        };



        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data
        ];

        return response()->json($data);
    }


    public function edit_contracter_order($id)
    {
        // Retrieve the contracter ledger order
        $data = DB::table('contracter_ledgers')
            ->leftJoin('contractors', 'contracter_ledgers.contractor_id', '=', 'contractors.id')
            ->leftJoin('products', 'contracter_ledgers.pro_id', '=', 'products.id')
            ->select(
                'contracter_ledgers.*',
                'contractors.name as contractor_name',
                'products.pro_name'
            )
            ->where('contracter_ledgers.id', $id)
            ->first();

        // Agar order hi na mile
        if (!$data) {
            return response()->json([
                'status' => 404,
                'message' => 'Contracter Order not found.',
            ]);
        }

        // Map contracter ledger data to response format
        $responseData = [
            'id' => $data->id,
            'contractor_id' => $data->contractor_id,
            'contractor_name' => $data->contractor_name,
            'pro_name' => $data->pro_name,
            'date' => $data->date,
            'batch_number' => $data->batch_number,
            'price' => $data->price,
            'labour_cost' => $data->labour_cost,
            'material_cost' => $data->material_cost,
            'total_price' => $data->total_price,
            'receive_amount' => $data->receive_amount,
            'advance' => $data->advance ?? 0,
            'cost' => $data->cost,
            'Payment_type' => $data->Payment_type ?? 'Cash',
            'bank_id' => $data->bank_id,
            'payment_status' => $data->payment_status ?? 'Pending',
        ];

        return response()->json([
            'status' => 200,
            'data' => $responseData,
        ]);
    }

    

    public function update_contracter_order(Request $request)
    {
        // Find the contracter ledger record by ID
        $data = DB::table('contracter_ledgers')->where('id', $request->input('order_id'))->first();

        if (!$data) {
            return response()->json(['status' => 404, 'message' => 'Data not found.']);
        }

        // Update the contracter ledger record
        DB::table('contracter_ledgers')
            ->where('id', $request->input('order_id'))
            ->update([
                'date' => Carbon::parse($request->input('date'))->format('Y-m-d'),
                'receive_amount' => $request->input('receive_amount'),
                'Payment_type' => $request->input('payment_type'),
                'bank_id' => $request->input('bank_id'),
                'payment_status' => $request->input('payment_status'),
                'updated_at' => now(),
            ]);

        // Handle payment deduction from cash or bank
        if ($request->payment_status === 'Paid') {
            $receiveAmount = floatval($request->receive_amount);
            
            if ($request->payment_type === "Cash") {
                // Deduct from hand_cash
                DB::table('hand_cashes')->decrement('cash_amount', $receiveAmount);

            } elseif ($request->payment_type === "Bank") {
                // Deduct from bank balance
                DB::table('banks')->where('id', $request->bank_id)
                    ->decrement('bank_balance', $receiveAmount);
            }
        }




        return response()->json(['status' => 200, 'message' => 'Data updated successfully.']);
    }

}