<?php

namespace App\Http\Controllers;

use App\Models\ContracterLedger;
use App\Models\Contractor;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ContractorController extends Controller
{
    

    public function load_contractor(Request $request)
    {
        // $users = User::all();

        // return view('admin.users', compact('users'));

        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $query = DB::table('contractors');


        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('contractors.name', 'like', '%' . $search . '%');
        }



        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $users = $query->get();

   

        $all_data = [];
        foreach ($users as $user) {

           

            $btn = '<td class="text-right">';

            // if (Auth::user()->can('view_supplier_ledger')) {
            //     $btn .= '<a href="' . route("supplier_ledger", $user->id) . '" class="btn btn-success btn-icon" data-toggle="tooltip" title="View" style="padding: 6px 10px;"><i class="fa-duotone fa-memo"></i></a>';

            // } 
            // $btn .= '<button id="advance_btn" data-advid="'.$user->id.'" class="btn btn-primary btn-icon" data-toggle="tooltip" title="Advance" style="margin-right: 3px">Adv</button>';
       
            if (Auth::user()->can('update_contractor')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_contractor')) {
                $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }
            $btn .= '</td>';

            if($user->contractor_image != ""){

                $image = '<img   height="50px" src="uploads/contractor_image/'.$user->contractor_image.'">';

            }else{

                $image = '<img  " height="50px" src="uploads/no_image.png">';

            }
          

            

            $all_data[] = [
                'id'                    => $user->id,
                'name'                  => $user->name,
                'phone'                 => $user->phone,
                'cnic'                  => $user->cnic,
                // 'total_advance'         => $user->total_advance,
                'designation'           => $user->designation,
                'contractor_image'      => $image,
                'btn'                   => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ];

        return response()->json($data);


    }

    public function insert_contractor(Request $request)
    {
        $user_cnic = Contractor::where('cnic', $request->input('cnic'))->exists();

        if($user_cnic){

            return response()->json([
                'status'=> "cnic_Exist",
            ]);

        }else{

            if ($request->hasFile('contractor_image')) {
                $image1 = $request->file('contractor_image');
                $contractor_image = hexdec(uniqid()).'.'.$image1->getClientOriginalExtension();
                $image1->move(public_path('/uploads/contractor_image/'), $contractor_image);
            } else {
                $sup_image = null; // Set to null if no front image is provided
            }


            $data = new Contractor();
            $data->name         = $request->input('name');
            $data->phone        = $request->input('phone');
            $data->emergency_contact        = $request->input('emergency_contact');

            $data->cnic        = $request->input('cnic');
            $data->designation        = $request->input('designation');
            $data->address        = $request->input('address');
            $data->contractor_image        = $contractor_image;


            $data->created_by   = Auth::id();

            $data->save();

            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function edit_contractor($id)
    {
        // Retrieve the sale with customer details
        $data = Contractor::findOrFail($id);

         
        return response()->json([
            'status' => 200,
            'data' => $data, 
        ]);
    }
    public function edit_payment($id)
    {
        // Retrieve the sale with customer details
        $data = Contractor::findOrFail($id);

         
        return response()->json([
            'status' => 200,
            'data' => $data, 
        ]);
    }

    public function update_contractor(Request $request)
    {
        $user_cnic =  Contractor::where('cnic', $request->input('cnic'))
        ->where('id', '!=', $request->input('contractor_id'))->exists();

        if($user_cnic){

            return response()->json([
                'status'=> "cnic_Exist",
            ]);

        }else{
            $user = Contractor::findOrFail($request->input('contractor_id'));
            if ($request->hasFile('contractor_image')) {
                // Check and delete old contractor image
                if ($user->contractor_image && file_exists(public_path('/uploads/contractor_image/' . $user->contractor_image))) {
                    unlink(public_path('/uploads/contractor_image/' . $user->contractor_image));
                }

                // Upload the new contractor image
                $image1 = $request->file('contractor_image');
                $contractor_image = hexdec(uniqid()) . '.' . $image1->getClientOriginalExtension();
                $image1->move(public_path('/uploads/contractor_image/'), $contractor_image);
                $user->contractor_image = $contractor_image;
            }

            $user->name         = $request->input('name');
            $user->phone        = $request->input('phone');
            $user->emergency_contact        = $request->input('emergency_contact');
            $user->cnic        = $request->input('cnic');
            $user->designation        = $request->input('designation');

            $user->address        = $request->input('address');
            $user->updated_by   = Auth::id();


            $user->save();
            

            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function delete_contractor($id)
    {
        $data = Contractor::find($id);

        $data->delete();

        return response()->json([
            'status'=>200
        ]);
    }

    public function get_contractor()
    {
        $contractor = Contractor::all();

        return response()->json($contractor);
    }


    public function update_payment(Request $request)
    {
      
        $user = Contractor::findOrFail($request->input('contractor_id'));
        // $user->total_advance               = $request->input('amount');
        $user->created_by           = Auth::id();
        $user->save();

        $ledger = new ContracterLedger();
        $ledger->contractor_id  = $request->input('contractor_id');
        $ledger->advance  = $request->input('amount');
        $ledger->date  = $request->input('date');

        $ledger->save();

        

        return response()->json([
            'status'=>200
        ]);

        
    }

}
