<?php

namespace App\Http\Controllers;

use App\Models\Employee;
use App\Models\Salary;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class EmployeeController extends Controller
{
    public function load_employees(Request $request)
    {
        // $users = User::all();

        // return view('admin.users', compact('users'));

        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $query = DB::table('employees');

        // Role-based filter
        if (!Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            $query->where('employees.created_by', Auth::id());
        }


        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('employees.emp_name', 'like', '%' . $search . '%');
        }



        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $users = $query->get();

   

        $all_data = [];
        foreach ($users as $user) {

           

            $btn = '<td class="text-right">';

            // View button
            $btn .= '<a href="' . route("employee_ledger", $user->id) . '" 
            class="btn btn-success btn-icon" data-toggle="tooltip" title="View" style="padding: 6px 10px;"><i class="fa-duotone fa-memo" style="margin-right: 3px"></i></a>';

            if (Auth::user()->can('update_employee')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_employee')) {
                $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }
            $btn .= '</td>';

            
            if($user->emp_image != ""){

                $image = '<img   height="50px" src="uploads/emp_image/'.$user->emp_image.'">';

            }else{

                $image = '<img  " height="50px" src="uploads/no_image.png">';

            }

            $all_data[] = [
                'id'                        => $user->id,
                'emp_name'                      => $user->emp_name, 

                'phone'                     => $user->phone, 
                'cnic'                      => $user->cnic,
                'emp_image'                 => $image,
                'btn'                       => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ];

        return response()->json($data);


    }

    public function insert_employee(Request $request)
    {
        $user_name = Employee::where('emp_name', $request->input('emp_name'))->exists();

        if($user_name){

            return response()->json([
                'status'=> "name_Exist",
            ]);
            
        }else{

            if ($request->hasFile('emp_image')) {
                $image1 = $request->file('emp_image');
                $emp_image = hexdec(uniqid()).'.'.$image1->getClientOriginalExtension();
                $image1->move(public_path('/uploads/emp_image/'), $emp_image);
            } else {
                $emp_image = null; // Set to null if no front image is provided
            }

            $data = new Employee();
            $data->emp_name             = $request->input('emp_name');
            $data->father_name          = $request->input('father_name');
            $data->phone            = $request->input('phone');
            $data->email        = $request->input('email');
            $data->cnic             = $request->input('cnic');
            $data->designation      = $request->input('designation');
            $data->emergency_contact = $request->input('emergency_contact');
            $data->monthly_salary = $request->input('monthly_salary');
            $data->address          = $request->input('address');
            $data->emp_image        = $emp_image;
            $data->created_by       = Auth::id();
            $data->save();

            // 2. Create Ledger (Salary entry)
            Salary::create([
                'employee_id'   => $data->id,
                'salary_per_day'=> $request->input('salary_per_day') ?? 0,
                'working_days'  => 0,
                'advance'       => 0,
                'debit'         => 0,
                'credit'        => 0,
                'total_salary'  => $request->input('monthly_salary'),
                'month'         => now()->format('Y-m'), // current month
                'status'        => 'Opening Account',
                'created_by'    => Auth::id(),

            ]);

            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function edit_employee($id)
    {

        $data = DB::table('employees')
        ->where('employees.id', $id)
        ->first();

         
        return response()->json([
            'status' => 200,
            'data' => $data, 
        ]);
    }

    public function update_employee(Request $request)
    {
        $user_name =  Employee::where('emp_name', $request->input('emp_name'))
        ->where('id', '!=', $request->input('emp_id'))->exists();

        if($user_name){

            return response()->json([
                'status'=> "name_Exist",
            ]);
            
        }else{

            $user = Employee::findOrFail($request->input('emp_id'));
            if ($request->hasFile('emp_image')) {
                // Check and delete old CNIC front image
                if ($user->emp_image && file_exists(public_path('/uploads/emp_image/' . $user->emp_image))) {
                    unlink(public_path('/uploads/emp_image/' . $user->emp_image));
                }
            
                // Upload the new CNIC front image
                $image1 = $request->file('emp_image');
                $emp_image = hexdec(uniqid()) . '.' . $image1->getClientOriginalExtension();
                $image1->move(public_path('/uploads/emp_image/'), $emp_image);
                $user->emp_image = $emp_image;
            }
            
            $user->emp_name                 = $request->input('emp_name');
            $user->father_name                 = $request->input('father_name');
            $user->phone                = $request->input('phone');
            $user->emergency_contact     = $request->input('emergency_contact');
            $user->cnic                 = $request->input('cnic'); 
            $user->email                 = $request->input('email'); 
            $user->designation                 = $request->input('designation'); 
            $user->monthly_salary                 = $request->input('monthly_salary'); 

            $user->address              = $request->input('address'); 
            $user->updated_by           = Auth::id();
            $user->save();
            

            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function delete_employee($id)
    {
        $data = Employee::find($id);

        $data->delete();

        return response()->json([
            'status'=>200
        ]);
    }


    public function get_employee()
    {
      
        $employee = Employee::all();
       

        return response()->json($employee);
    }










    // ledger area 
    // public function load_employee_ledger(Request $request)
    // {
    //     $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
    //     $end_date   = !empty($request->input('enddate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
    //     $limit      = $request->input('length');
    //     $offset     = $request->input('start');
    //     $column     = $request->input('order.0.column');
    //     $dir        = $request->input('order.0.dir');
    //     $order_by   = $request->input("columns.$column.data");
    
    //     // Build the query with potential filters
    //     $query = DB::table('salaries')
    //         ->where('salaries.employee_id', '=', $request->input('emp_id'));
    //     if (!empty($start_date) && !empty($end_date)) {
    //         $query->whereBetween('salaries.date', [$start_date, $end_date]);
    //     }
    //     // dd($query);
    
    //     if ($search = $request->input('search')) { // .value if using DataTables
    //         $query->where('detail', 'like', '%' . $search . '%');
    //     }
    //     $type = $request->input('type');
    //     if (isset($type)) {
    //         $query->where('payment_type', '=', $type);
    //     }
    
    //     $totalsQuery = clone $query;
    //     $totals = $totalsQuery->select([
    //         DB::raw('SUM(credit) as total_credit'),

    //         DB::raw('SUM(debit) as total_debit')
    //     ])->first();
    
    //     // Calculate total before pagination
    //     $total_count = $query->count();
    
    //     // Fetch the data
    //     $supplier_ledger = $query->get();
    
    //     $all_data = [];
    //     $currentBalance = 0;
    
    //     foreach ($supplier_ledger as $data) {
          

    //         if ($data->credit > 0) {
    //             $currentBalance -= $data->credit;
    //         }
    //         if ($data->debit > 0) {
    //             $currentBalance += $data->credit + $data->debit;
    //         }
           
    
    //         // Default transaction type (to prevent undefined errors)
    //         $payment_type = '<div class="label label-table label-default" style="width:100%; max-width:130px;">Unknown</div>';
    
    //         if ($data->payment_type == "Cash") {
    //             $payment_type = '<div class="label label-table label-purple" style="width:100%; max-width:130px;">' . $data->payment_type . '</div>';
    //         } else if ($data->payment_type == "Bank") {
    //             $payment_type = '<div class="label label-table label-warning" style="width:100%; max-width:130px;">' . $data->payment_type . '</div>';
    //         }
    //         else if ($data->payment_type == "credit") {
    //             $payment_type = '<div class="label label-table label-warning" style="width:100%; max-width:130px;">Cash</div>';
    //         }
    
    //         $btn = "";
    
    //         if ($data->employee_id != null || $data->employee_id > 0) {
    //             $btn = '<td class="text-right">
    //                         <button id="view_sale_btn" data-sale_id="' . $data->employee_id . '" class="btn btn-success btn-icon" data-toggle="tooltip" title="View" style="padding: 6px 10px;"><i class="fa-duotone fa-memo"></i></button>
    //                     </td>';
    //         }
    //          else  if ($data->employee_id != null || $data->employee_id > 0) {
    //             $btn = '<td class="text-right">
    //                         <button id="view_ret_btn" data-ret_id="' . $data->employee_id . '" class="btn btn-success btn-icon" data-toggle="tooltip" title="View" style="padding: 6px 10px;"><i class="fa-duotone fa-memo"></i></button>
    //                         <button id="edit_btn" data-eid="' . $data->id . '" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit"><i class="fa-duotone fa-pen-to-square"></i></button>
    //                     </td>';
    //         } 
    //         else if ($data->employee_id == null && $data->employee_id == null && $data->payment_type != "Cash") {
    //             $btn = '<td class="text-right">
    //                         <button id="edit_btn" data-eid="' . $data->id . '" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit"><i class="fa-duotone fa-pen-to-square"></i></button>
    //                         <button id="delete_btn" data-did="' . $data->id . '" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>
    //                     </td>';
    //         }
    
    //         $all_data[] = [
    //             'id'                 => $data->id,
    //             'date'   => Carbon::parse($data->date)->format('d-m-Y'),
    //             'payment_type'   => $payment_type,
    //             'credit'             => number_format($data->credit, 0),
    //             'debit'              => number_format($data->debit, 0),
    //             'balance'            => number_format($currentBalance, 0),
    //             'btn'                => $btn
    //         ];
    //     }
    
    //     $emp_name = Employee::find($request->input('emp_id'));
    
    //     $total_results = array(
    //         "total_debit"     => ($totals->total_debit > 0) ? number_format($totals->total_debit) : 0,
    //         "total_credit"    => ($totals->total_credit > 0) ? number_format($totals->total_credit) : 0,
    //         "employee_name"   => $emp_name->emp_name . " Ledger (ID: " . $emp_name->id . ")",
    //     );
    
    //     $data = [
    //         "draw"            => intval($request->input('draw')),
    //         "recordsTotal"    => $total_count,
    //         "recordsFiltered" => $total_count,
    //         "data"            => $all_data,
    //         "totals"          => $total_results,
    //     ];
    
    //     return response()->json($data);
    // }

    // all emplyeee ledger 
    public function load_all_employee_ledger(Request $request)
    {
        // $emp_id = $request->input('emp_id');
        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m') : "";
        $end_date   = !empty($request->input('enddate')) ? Carbon::parse($request->input('enddate'))->format('Y-m') : "";

        // Build query
        $query = DB::table('salaries')
        ->leftJoin('employees', 'salaries.employee_id', '=', 'employees.id')
        ->select(
            'salaries.*',
            'employees.emp_name',   // employee ka naam
            'employees.designation'         // agar designation bhi chahiye
        );


        // Filter by month range
        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('month', [$start_date, $end_date]);
        }

    
        if ($month = $request->input('type')) {   // ðŸ‘ˆ yahan 'type' use karna hai
            $monthMap = [
                'january'   => '01',
                'february'  => '02',
                'march'     => '03',
                'april'     => '04',
                'may'       => '05',
                'june'      => '06',
                'july'      => '07',
                'august'    => '08',
                'september' => '09',
                'october'   => '10',
                'november'  => '11',
                'december'  => '12',
            ];

            if (isset($monthMap[$month])) {
                $query->where('salaries.month', 'like', "%-" . $monthMap[$month]);
            }
        }



        // Count total
        $total_count = $query->count();

        // Fetch records
        $salaries = $query->orderBy('month', 'desc')->get();

        $all_data = [];
        $total_paid = 0;
        $total_unpaid = 0;

        foreach ($salaries as $salary) {
            $net_salary = ($salary->salary_per_day * $salary->working_days) - $salary->advance;

            if ($salary->status == "paid") {
                $total_paid += $net_salary;
            } else {
                $total_unpaid += $net_salary;
            }

            if ($salary->status == "paid") {
                $status_label = '<div class="label label-success">Paid</div>';
            } elseif ($salary->status == "unpaid") {
                $status_label = '<div class="label label-danger">Unpaid</div>';
            } elseif ($salary->status == "Opening Account") {
                $status_label = '<div class="label label-primary">Opening Account</div>';
            } else {
                $status_label = '<div class="label label-default">Unknown</div>';
            }


            // $btn = '<button id="edit_btn" data-eid="' . $salary->id . '" class="btn btn-success btn-icon" title="Edit"><i class="fa-duotone fa-pen-to-square"></i></button>';

            $all_data[] = [
                'id'            => $salary->id,
                'emp_name'            => $salary->emp_name,
                'net_salary'    => number_format($net_salary, 0),
                'advance'       => number_format($salary->advance, 0),
                'month'         => $salary->month,
                'date'         => $salary->date,
                'salary_per_day'=> number_format($salary->salary_per_day, 0),
                'working_days'  => $salary->working_days,
                'status'        => $status_label,
                'btn'           => $salary->signature ?? '',
            ];
        }

        // $emp = Employee::find($emp_id);

        $totals = [
            "total_paid"   => number_format($total_paid, 0),
            "total_unpaid" => number_format($total_unpaid, 0),
            // "employee_name" => $emp->emp_name . " Ledger (ID: " . $emp->id . ")",
        ];

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
            "totals"          => $totals,
        ];

        return response()->json($data);
    }

    public function employee()
    {
        try {
            $employee_id = null;
            
            // If user has Employee role, find their employee record and show ledger
            if (Auth::user()->hasRole('Employee')) {
                $user = Auth::user();
                
                // First try to find by email (most reliable match)
                $employee = null;
                if ($user->email) {
                    $employee = Employee::where('email', $user->email)->first();
                }
                
                // If not found by email, try created_by
                if (!$employee) {
                    $employee = Employee::where('created_by', $user->id)->first();
                }
                
                // If still not found, try to find any employee with matching name (case-insensitive)
                if (!$employee && $user->name) {
                    $employee = Employee::whereRaw('LOWER(emp_name) LIKE ?', ['%' . strtolower($user->name) . '%'])->first();
                }
                
                // If still not found, try exact match ignoring case
                if (!$employee && $user->name) {
                    $employee = Employee::whereRaw('LOWER(TRIM(emp_name)) = ?', [strtolower(trim($user->name))])->first();
                }
                
                // If still not found, try partial match (remove spaces and compare)
                if (!$employee && $user->name) {
                    $userNameClean = preg_replace('/\s+/', '', strtolower($user->name));
                    $employees = Employee::all();
                    foreach ($employees as $emp) {
                        $empNameClean = preg_replace('/\s+/', '', strtolower($emp->emp_name ?? ''));
                        // Exact match
                        if ($userNameClean === $empNameClean) {
                            $employee = $emp;
                            break;
                        }
                        // Similar match (using similar_text for fuzzy matching)
                        $similarity = 0;
                        similar_text($userNameClean, $empNameClean, $similarity);
                        if ($similarity > 85) { // 85% similarity threshold
                            $employee = $emp;
                            break;
                        }
                    }
                }
                
                if ($employee) {
                    $employee_id = $employee->id;
                } else {
                    // If employee record not found, show a message but still render the page
                    // The user will see an empty table with a message
                    $employee_id = null;
                    // Log for debugging
                    Log::warning('Employee record not found for user: ' . $user->email . ' (ID: ' . $user->id . ')');
                }
            }
            
            // For Employee role: show ledger view with employee_id, for others: show employee list
            return view('admin.employee', compact('employee_id'));
        } catch (\Exception $e) {
            // Log error and redirect to dashboard
            Log::error('Error in employee() method: ' . $e->getMessage());
            return redirect()->route('dashboard')->with('error', 'An error occurred. Please try again.');
        }
    }

    public function show_employee_ledger($id)
    {
        // If user has Employee role, validate they can only access their own ledger
        if (Auth::user()->hasRole('Employee')) {
            // First try to find by email (most reliable match)
            $employee = Employee::where('email', Auth::user()->email)->first();
            
            // If not found by email, try created_by
            if (!$employee) {
                $employee = Employee::where('created_by', Auth::id())->first();
            }
            
            // If still not found, try to find any employee with matching name (last resort)
            if (!$employee) {
                $employee = Employee::where('emp_name', Auth::user()->name)->first();
            }
            
            // Redirect to their own ledger if trying to access another employee's ledger
            if ($employee && $employee->id != $id) {
                return redirect()->route('employee_ledger', $employee->id);
            } elseif (!$employee) {
                return redirect()->route('dashboard')->with('error', 'Employee record not found. Please contact administrator.');
            }
        }
        
        // For other roles or valid access, show the employee ledger page
        return view('admin.employee_ledger');
    }

    public function load_employee_ledger(Request $request)
    {
        try {
            $emp_id = $request->input('emp_id');
            
            // Validate emp_id
            if (empty($emp_id)) {
                return response()->json([
                    'draw' => intval($request->input('draw', 0)),
                    'recordsTotal' => 0,
                    'recordsFiltered' => 0,
                    'data' => [],
                    'error' => 'Employee ID is required'
                ], 400);
            }

            $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m') : "";
            $end_date   = !empty($request->input('enddate')) ? Carbon::parse($request->input('enddate'))->format('Y-m') : "";

            // CRITICAL: If user has Employee role, FORCE them to only see their own data
            if (Auth::user()->hasRole('Employee')) {
                // Use the same matching logic as in employee() method to find current employee
                $user = Auth::user();
                $employee = null;
                
                // First try to find by email (most reliable match)
                if ($user->email) {
                    $employee = Employee::where('email', $user->email)->first();
                }
                
                // If not found by email, try created_by
                if (!$employee) {
                    $employee = Employee::where('created_by', $user->id)->first();
                }
                
                // If still not found, try to find any employee with matching name (case-insensitive)
                if (!$employee && $user->name) {
                    $employee = Employee::whereRaw('LOWER(emp_name) LIKE ?', ['%' . strtolower($user->name) . '%'])->first();
                }
                
                // If still not found, try exact match ignoring case
                if (!$employee && $user->name) {
                    $employee = Employee::whereRaw('LOWER(TRIM(emp_name)) = ?', [strtolower(trim($user->name))])->first();
                }
                
                // If still not found, try partial match (remove spaces and compare with fuzzy matching)
                if (!$employee && $user->name) {
                    $userNameClean = preg_replace('/\s+/', '', strtolower($user->name));
                    $employees = Employee::all();
                    foreach ($employees as $emp) {
                        $empNameClean = preg_replace('/\s+/', '', strtolower($emp->emp_name ?? ''));
                        // Exact match
                        if ($userNameClean === $empNameClean) {
                            $employee = $emp;
                            break;
                        }
                        // Similar match (using similar_text for fuzzy matching)
                        $similarity = 0;
                        similar_text($userNameClean, $empNameClean, $similarity);
                        if ($similarity > 85) { // 85% similarity threshold
                            $employee = $emp;
                            break;
                        }
                    }
                }
                
                // CRITICAL: Force emp_id to be ONLY the current employee's ID - ignore any other emp_id sent
                if ($employee) {
                    $emp_id = $employee->id; // Always use the employee's own ID
                    Log::info('Employee role user ' . $user->email . ' accessing their own ledger (Employee ID: ' . $emp_id . ')');
                } else {
                    Log::warning('Employee role user ' . $user->email . ' - employee record not found');
                    return response()->json([
                        'draw' => intval($request->input('draw', 0)),
                        'recordsTotal' => 0,
                        'recordsFiltered' => 0,
                        'data' => [],
                        'error' => 'Access denied. Employee record not found.'
                    ], 403);
                }
            }

            // Build query - ALWAYS filter by the specific employee_id
            $query = DB::table('salaries')
                ->where('employee_id', $emp_id);

            // Filter by month range
            if (!empty($start_date) && !empty($end_date)) {
                $query->whereBetween('month', [$start_date, $end_date]);
            }

            // Search filter - handle both DataTables format and custom search
            $search = $request->input('search');
            if (is_array($search) && isset($search['value'])) {
                $searchValue = $search['value'];
            } else {
                $searchValue = $request->input('search');
            }
            
            if (!empty($searchValue)) {
                $query->where(function($q) use ($searchValue) {
                    $q->where('month', 'like', '%' . $searchValue . '%')
                      ->orWhere('date', 'like', '%' . $searchValue . '%')
                      ->orWhere('status', 'like', '%' . $searchValue . '%');
                });
            }

            // Count total before pagination
            $total_count = $query->count();

            // Get DataTables pagination parameters
            $limit = $request->input('length', 25);
            $offset = $request->input('start', 0);
            $order_column = $request->input('order.0.column', 1);
            $order_dir = $request->input('order.0.dir', 'desc');

            // Fetch records with pagination
            $salaries = $query->orderBy('month', $order_dir)
                             ->offset($offset)
                             ->limit($limit)
                             ->get();

        $all_data = [];
        $total_paid = 0;
        $total_unpaid = 0;

        foreach ($salaries as $salary) {
            $net_salary = ($salary->salary_per_day * $salary->working_days) - $salary->advance;

            if ($salary->status == "paid") {
                $total_paid += $net_salary;
            } else {
                $total_unpaid += $net_salary;
            }

            if ($salary->status == "paid") {
                $status_label = '<div class="label label-success">Paid</div>';
            } elseif ($salary->status == "unpaid") {
                $status_label = '<div class="label label-danger">Unpaid</div>';
            } elseif ($salary->status == "Opening Account") {
                $status_label = '<div class="label label-primary">Opening Account</div>';
            } else {
                $status_label = '<div class="label label-default">Unknown</div>';
            }


            // $btn = '<button id="edit_btn" data-eid="' . $salary->id . '" class="btn btn-success btn-icon" title="Edit"><i class="fa-duotone fa-pen-to-square"></i></button>';

            $all_data[] = [
                'id'            => $salary->id,
                'month'         => $salary->month,
                'date'         => $salary->date,

                'salary_per_day'=> number_format($salary->salary_per_day, 0),
                'working_days'  => $salary->working_days,
                'advance'       => number_format($salary->advance, 0),
                'net_salary'    => number_format($net_salary, 0),
                'status'        => $status_label,
                // 'btn'           => $btn
            ];
        }

            $emp = Employee::find($emp_id);

            if (!$emp) {
                return response()->json([
                    'draw' => intval($request->input('draw', 0)),
                    'recordsTotal' => 0,
                    'recordsFiltered' => 0,
                    'data' => [],
                    'error' => 'Employee not found'
                ], 404);
            }

            $totals = [
                "total_paid"   => number_format($total_paid, 0),
                "total_unpaid" => number_format($total_unpaid, 0),
                "employee_name" => $emp->emp_name . " Ledger (ID: " . $emp->id . ")",
            ];

            $data = [
                "draw"            => intval($request->input('draw', 1)),
                "recordsTotal"    => $total_count,
                "recordsFiltered" => $total_count,
                "data"            => $all_data,
                "totals"          => $totals,
            ];

            return response()->json($data);
        } catch (\Exception $e) {
            Log::error('Error in load_employee_ledger: ' . $e->getMessage() . ' | Trace: ' . $e->getTraceAsString());
            return response()->json([
                'draw' => intval($request->input('draw', 0)),
                'recordsTotal' => 0,
                'recordsFiltered' => 0,
                'data' => [],
                'error' => 'An error occurred while loading employee ledger data.'
            ], 500);
        }
    }

    

    public function insert_employee_payment(Request $request)
    {
        // Prevent Employee role from inserting payments
        if (Auth::user()->hasRole('Employee')) {
            return response()->json([
                'status' => 403,
                'message' => 'Access denied. You do not have permission to add payments.'
            ], 403);
        }
        
        // Set credit and debit amounts based on transaction type
        $credit = $request->input('transaction_type') == "credit" ? $request->input('amount') : 0;
        $bank = $request->input('transaction_type') == "bank" ? $request->input('amount') : 0;
        $amount = $request->input('amount');

        if ($request->transaction_type === "credit") {
            // hand_cash column
            DB::table('hand_cashes')->decrement('cash_amount', $amount);

            // Record transaction
            DB::table('transactions')->insert([
                'payment_type'      => 'Cash',
                'amount'            => $amount,
                'transaction_type'  => 'withdraw',
                'source_type'       => 'Employee Salary',
                'source_id'         => $request->input('cus_pay_id'),
                'description'       => 'Employee Salary Payment',
                'created_at'        => now(),
            ]);

        } elseif ($request->transaction_type === "bank") {

            DB::table('banks')->where('id', $request->bank_id)
            ->decrement('bank_balance', $amount);

            // Record transaction
            DB::table('transactions')->insert([
                'payment_type'      => 'Bank',
                'bank_id'           => $request->input('bank_id'),
                'amount'            => $amount,
                'transaction_type'  => 'withdraw',
                'source_type'       => 'Employee Salary',
                'source_id'         => $request->input('cus_pay_id'),
                'description'       => 'Employee Salary Payment',
                'created_at'        => now(),
            ]);
        }

    
        $customer_ledger = new Salary();
        $customer_ledger->employee_id = $request->input('cus_pay_id');
        $customer_ledger->date = Carbon::parse($request->input('transaction_date'))->format('Y-m-d'); // Correct transaction_date field
    
        $customer_ledger->payment_type = $request->input('transaction_type');
        $customer_ledger->bank_id = $request->input('bank_id');
        $customer_ledger->working_days = $request->input('working_days');
        $customer_ledger->salary_per_day = $request->input('salary_per_day');
        $customer_ledger->advance = $request->input('advance');

        $customer_ledger->status = 'paid';


        $customer_ledger->credit = $credit;
        $customer_ledger->credit = $bank;
        $customer_ledger->month = now()->format('Y-m'); // current month
        $customer_ledger->created_by = Auth::id();
        $customer_ledger->updated_by = Auth::id();
    
        // Save the entry
        $customer_ledger->save();
    
        return response()->json([
            'status' => 200
        ]);
    }

    
    public function insert_employee_advance(Request $request)
    {
        // Prevent Employee role from inserting advances
        if (Auth::user()->hasRole('Employee')) {
            return response()->json([
                'status' => 403,
                'message' => 'Access denied. You do not have permission to add advances.'
            ], 403);
        }
        
        // Set credit and debit amounts based on transaction type
        $credit = $request->input('transaction_type') == "credit" ? $request->input('advance') : 0;
        $bank = $request->input('transaction_type') == "bank" ? $request->input('advance') : 0;
        $advanceAmount = $request->input('advance');

        if ($request->transaction_type === "credit") {
            // hand_cash column
            DB::table('hand_cashes')->decrement('cash_amount', $advanceAmount);

            // Record transaction
            DB::table('transactions')->insert([
                'payment_type'      => 'Cash',
                'amount'            => $advanceAmount,
                'transaction_type'  => 'withdraw',
                'source_type'       => 'Employee Advance',
                'source_id'         => $request->input('cus_pay_id'),
                'description'       => 'Employee Advance Payment',
                'created_at'        => now(),
            ]);

        } elseif ($request->transaction_type === "bank") {

            DB::table('banks')->where('id', $request->bank_id)
            ->decrement('bank_balance', $advanceAmount);

            // Record transaction
            DB::table('transactions')->insert([
                'payment_type'      => 'Bank',
                'bank_id'           => $request->input('bank_id'),
                'amount'            => $advanceAmount,
                'transaction_type'  => 'withdraw',
                'source_type'       => 'Employee Advance',
                'source_id'         => $request->input('cus_pay_id'),
                'description'       => 'Employee Advance Payment',
                'created_at'        => now(),
            ]);
        }

    
        $customer_ledger = new Salary();
        $customer_ledger->employee_id = $request->input('cus_pay_id');
        $customer_ledger->date = Carbon::parse($request->input('transaction_date'))->format('Y-m-d'); // Correct transaction_date field
    
        $customer_ledger->payment_type = $request->input('transaction_type');
        $customer_ledger->bank_id = $request->input('bank_id');
        $customer_ledger->advance = $request->input('advance');

        $customer_ledger->status = 'paid';


        $customer_ledger->credit = $credit;
        $customer_ledger->credit = $bank;
        $customer_ledger->month = $request->transaction_month;
        $customer_ledger->created_by = Auth::id();
        $customer_ledger->updated_by = Auth::id();
    
        // Save the entry
        $customer_ledger->save();
    
        return response()->json([
            'status' => 200
        ]);
    }

    public function getMonthlyAdvance($emp_id)
    {
        $month = Carbon::now()->month;
        $year  = Carbon::now()->year;

        $totalAdvance = Salary::where('employee_id', $emp_id)
                            ->whereMonth('created_at', $month)
                            ->whereYear('created_at', $year)
                            ->sum('advance');

        return response()->json([
            'status' => 200,
            'totalAdvance' => $totalAdvance,
        ]);
    }

    public function getEmployeePaymentData($emp_id)
    {
        $employee = Employee::find($emp_id);
        
        if (!$employee) {
            return response()->json([
                'status' => 404,
                'message' => 'Employee not found',
            ]);
        }

        $month = Carbon::now()->month;
        $year  = Carbon::now()->year;

        $totalAdvance = Salary::where('employee_id', $emp_id)
                            ->whereMonth('created_at', $month)
                            ->whereYear('created_at', $year)
                            ->sum('advance');

        // Calculate salary per day from monthly salary
        $salaryPerDay = $employee->monthly_salary ? ($employee->monthly_salary / 30) : 0;

        return response()->json([
            'status' => 200,
            'monthly_salary' => $employee->monthly_salary ?? 0,
            'salary_per_day' => round($salaryPerDay, 2),
            'current_advance' => $totalAdvance ?? 0,
        ]);
    }



    // pending function 
    public function edit_employee_payment($id)
    {
        // model relation ship
        $Data = Salary::with('bank')->find($id);

        if ($Data && $Data->date) {
            $Data->date = Carbon::parse($Data->date)->format('d-m-Y');
        }
        if ($Data) {
            $Data->ledger_bank_amount = $Data->bank; // yahan customer_ledgers.bank column
        }


        return response()->json([
            'status' => 200,
            'data'   => $Data,
        ]);
    }


    public function update_customer_payment(Request $request)
    {

        if($request->input('transaction_type') == "credit"){

            $credit = $request->input('amount');
            $debit = 0;
            $bank = 0;


        }else if($request->input('transaction_type') == "debit"){

            $credit = 0;
            $bank = 0;
            $debit = $request->input('amount');
        }
        else if($request->input('transaction_type') == "bank"){

            $credit = 0;
            $debit = 0;
            $bank = $request->input('amount');
        }

        
        if ($request->transaction_type === "credit") {
            // hand_cash column
            DB::table('hand_cashes')->increment('cash_amount', $request->amount);

        } elseif ($request->transaction_type === "bank") {

            DB::table('banks')->where('id', $request->bank_id)
            ->increment('bank_balance', $request->amount);
        }
 
        $customer_ledger                = CustomerLedger::find($request->input('pay_id'));
        $customer_ledger->invoice_date  = Carbon::parse($request->input('transaction_date'))->format('Y-m-d');
        $customer_ledger->detail        = ($request->input('transaction_details') != "")?$request->input('transaction_details'):"Payment";
        $customer_ledger->credit        = $credit;
        $customer_ledger->debit         = $debit;
        $customer_ledger->bank          = $bank;

        $customer_ledger->updated_by       = Auth::id();

        $customer_ledger->save();

        return response()->json([
            'status'=>200
        ]);

    }


    public function delete_customer_payment($delete_id)
    {
        $payment = CustomerLedger::find($delete_id)->delete();

        return response()->json([
            'status'=>200
        ]);
    }






}