<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ExchangeRateController extends Controller
{
    public function getRate()
    {
        $response = Http::get('https://open.er-api.com/v6/latest/USD');

        if ($response->successful()) {
            return response()->json([
                'rate' => $response->json()['rates']['PKR']
            ]);
        } else {
            return response()->json(['error' => 'Unable to fetch exchange rate'], 500);
        }
    }
}
