<?php

namespace App\Http\Controllers;

use App\Models\ExpenseSubCategory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ExpenseSubCategoryController extends Controller
{
    public function load_expense_sub_categories(Request $request)
    {
        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        // Build the query with potential filters
        $query = DB::table('expense_sub_categories')
            ->select()->where('is_deleted', '!=', 1);

        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('exp_sub_cat_name', 'like', '%' . $search . '%');
        }
        $type = $request->input('type');
        if (isset($type)) {
            $query->where('is_deleted', '=', $type);
        }

        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $categories = $query->get();

        $all_data = [];
        foreach ($categories as $data) {

            $btn = '<td class="text-right">
                        <button id="edit_btn" data-eid="'.$data->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit"><i class="fa-duotone fa-pen-to-square"></i></button>
                        <button id="delete_btn" data-did="'.$data->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>
                    </td>
                    ';

            $all_data[] = [
                'id'            => $data->id,
                'exp_sub_cat_name'  => $data->exp_sub_cat_name,
                'btn'           => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data
        ];

        return response()->json($data);
    }


    public function insert_expense_sub_category(Request $request)
    {

        $cat_name = ExpenseSubCategory::where('exp_sub_cat_name', $request->input('cat_name'))->exists();

        if($cat_name){

            return response()->json([
                'status'=> "categoryExist",
            ]);

        }else{

            $Categories = new ExpenseSubCategory();
            $Categories->exp_cat_id          = $request->input('category_id');
            $Categories->exp_sub_cat_name    = $request->input('cat_name');
            $Categories->created_by    = Auth::id();
            $Categories->updated_by    = Auth::id();

            $Categories->save();

            return response()->json([
                'status'=>200
            ]);

        }
    }


    public function edit_expense_sub_category($id)
    {
        $Data = ExpenseSubCategory::find($id);

        return response()->json([
            'status'=>200,
            'data' => $Data,
        ]);
    }


    public function update_expense_sub_category(Request $request)
    {
        $categories =  ExpenseSubCategory::where('exp_sub_cat_name', $request->input('cat_name'))
        ->where('id', '!=', $request->input('cat_id'))->exists();

        if($categories){

            return response()->json([
                'status'=> "categoryExist",
            ]);
            
        }else{
            
            $Categories = ExpenseSubCategory::find($request->input('cat_id'));
            $Categories->exp_sub_cat_name      = $request->input('cat_name');
            $Categories->updated_by      = Auth::id();

            $Categories->save();

            return response()->json([
                'status'=>200
            ]);

        }
    }


    public function delete_expense_sub_category($id)
    {
        $Categories = ExpenseSubCategory::find($id);
 

        $Categories->delete();
        return response()->json([
            'status'=>200
        ]);
    }


    public function get_expense_sub_categories(Request $request)
    {
        $query = $request->get('query');
        $cat_id = $request->get('cat_id');

        $subCategories = ExpenseSubCategory::where('exp_sub_cat_name', 'LIKE', "%{$query}%")
            ->where('is_deleted', '!=', 1);

        // Filter by category if provided
        if ($cat_id) {
            $subCategories->where('exp_cat_id', $cat_id);
        }

        $subCategories = $subCategories->select('id', 'exp_sub_cat_name')->get();

        return response()->json($subCategories);
    }
}
