<?php

namespace App\Http\Controllers;

use App\Models\HandCash;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HandCashController extends Controller
{
    

     public function load_hand_cash(Request $request)
    {
        // $users = User::all();

        // return view('admin.users', compact('users'));

        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $query = DB::table('hand_cashes');

        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('hand_cashes.cash_amount', 'like', '%' . $search . '%');
        }



        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $users = $query->get();

   

        $all_data = [];
        foreach ($users as $user) {

           

            $btn = '<td class="text-right">';
            if (Auth::user()->can('update_user')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            // if (Auth::user()->can('delete_user')) {
            //     $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            // }
            $btn .= '</td>';


            $all_data[] = [
                'id'            => $user->id,
                'cash_amount'          => $user->cash_amount,
                'btn'           => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ];

        return response()->json($data);


    }

    public function insert_hand_cash(Request $request)
    {
        $data = new HandCash();
        $data->cash_amount         = $request->input('cash_amount');

        $data->created_by   = Auth::id();

        $data->save();

        return response()->json([
            'status'=>200
        ]);
    }

    public function edit_hand_cash($id)
    {
        // Retrieve the sale with customer details
        $data = HandCash::findOrFail($id);

         
        return response()->json([
            'status' => 200,
            'data' => $data, 
        ]);
    }

    public function update_hand_cash(Request $request)
    {
    

        $user                       = HandCash::findOrFail($request->input('cash_id'));
        $user->cash_amount          += $request->input('cash_amount');
        $user->updated_by           = Auth::id();
        $user->save();
        

        return response()->json([
            'status'=>200
        ]);
    }

    public function delete_hand_cash($id)
    {
        $data = HandCash::find($id);

        $data->delete();

        return response()->json([
            'status'=>200
        ]);
    }

    
    public function totalcash()
    {
        $total = HandCash::sum('cash_amount'); // jitne bhi rows hain sab ka total

        return response()->json([
            'total_cash' => $total
        ]);
    }



}
