<?php

namespace App\Http\Controllers;

use App\Models\Investment;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class InvestmentController extends Controller
{
    
    public function load_inv_investments(Request $request)
    {
        // $users = User::all();

        // return view('admin.users', compact('users'));

        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $query = DB::table('investments')
        ->leftJoin('investors', 'investments.investor_id', '=', 'investors.id')
        ->leftJoin('products', 'investments.pro_id', '=', 'products.id')
        ->select(
            'investments.*',
            'investors.investor_name',
            'products.pro_name'
        );

        // Role-based filter
        if (!Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            $query->where('investments.investor_id', Auth::id());
        }


        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('investments.created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('investors.investor_name', 'like', '%' . $search . '%');
        }



        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $users = $query->get();

   

        $all_data = [];
        foreach ($users as $user) {

           

            $btn = '<td class="text-right">';

            // View button
            // $btn .= '<a href="' . route("customer_ledger", $user->id) . '" 
            // class="btn btn-success btn-icon" data-toggle="tooltip" title="View" style="padding: 6px 10px;"><i class="fa-duotone fa-memo" style="margin-right: 3px"></i></a>';

            if (Auth::user()->can('update_investor_investment')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_investor_investment')) {
                $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }
            $btn .= '</td>';

            

            $all_data[] = [
                'id'                        => $user->id,
                'investor_name'                      => $user->investor_name,
                'pro_name'                => $user->pro_name,
                'invested_amount'           => $user->invested_amount,
                // 'remaining_amount'           => $user->remaining_amount,
                'profit_percentage'                     => $user->profit_percentage,
                'date'                 => $user->date,
                // 'btn'                       => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ];

        return response()->json($data);


    }

    public function insert_inv_investment(Request $request)
    {
        

        $data = new Investment();
        $data->investor_id              = $request->input('investor_id');
        $data->pro_id                   = $request->input('pro_id');
        $data->payment_type             = $request->input('payment_type');

        // investor paymrnt add in to company balanve
        if ($request->payment_type === "Cash") {
            // hand_cash column
            DB::table('hand_cashes')->increment('cash_amount', $request->invested_amount);

            DB::table('transactions')->insert([
                'payment_type' => 'Cash',
                'amount' => $request->invested_amount,
                'transaction_type' => 'deposit',
                'source_type' => 'Investor Investment',
                'source_id' => $data->id,
                'description' => 'Investor Investment Made',
                'created_at' => now(),
            ]);

        } elseif ($request->payment_type === "Bank") {

            DB::table('banks')->where('id', $request->bank_id)
            ->increment('bank_balance', $request->invested_amount);

            DB::table('transactions')->insert([
                'payment_type' => 'Bank',
                'bank_id' => $request->bank_id,
                'amount' => $request->invested_amount,
                'transaction_type' => 'deposit',
                'source_type' => 'Investor Investment',
                'source_id' => $data->id,
                'description' => 'Investor Investment Made',
                'created_at' => now(),
            ]);
        }

        $data->bank_id                  = $request->input('bank_id');
        $data->invested_amount          = $request->input('invested_amount');
        $data->remaining_amount          = $request->input('invested_amount');
        $data->profit_percentage          = $request->input('profit_percentage');
        $data->date                     = Carbon::parse($request->input('date'))->format('Y-m-d');
        $data->created_by       = Auth::id();
        $data->save();

         

        return response()->json([
            'status'=>200
        ]);

    }

    public function edit_inv_investment($id)
    {

        $data = DB::table('investments')
        ->leftJoin('investors', 'investments.investor_id', '=', 'investors.id')
        ->leftJoin('products', 'investments.pro_id', '=', 'products.id')
        ->leftJoin('banks', 'investments.bank_id', '=', 'banks.id')

        ->select(
            'investments.*',
            'investors.investor_name',
            'products.pro_name',
            'banks.bank_name'
        )
        ->where('investments.id', $id)
        ->first();

         
        return response()->json([
            'status' => 200,
            'data' => $data, 
        ]);
    }

    public function update_inv_investment(Request $request)
    {
        

        $user = Investment::findOrFail($request->input('investment_id'));
        $user->investor_id                 = $request->input('investor_id');
        $user->pro_id                = $request->input('pro_id');
        $user->payment_type                 = $request->input('payment_type');
        $user->bank_id            = $request->input('bank_id');
        $user->invested_amount              += $request->input('new_add_amount');
        $user->remaining_amount              += $request->input('new_add_amount');
        $user->profit_percentage           = $request->input('profit_percentage');
        $user->updated_by           = Auth::id();

        // investor paymrnt add in to company balanve
        if ($request->payment_type === "Cash") {
            // hand_cash column
            DB::table('hand_cashes')->increment('cash_amount', $request->new_add_amount);

        } elseif ($request->payment_type === "Bank") {

            DB::table('banks')->where('id', $request->bank_id)
            ->increment('bank_balance', $request->new_add_amount);
        }


        $user->save();
        

        return response()->json([
            'status'=>200
        ]);

    }

    public function delete_inv_investment($id)
    {
        $data = Investment::find($id);

        $data->delete();

        return response()->json([
            'status'=>200
        ]);
    }


    public function get_inv_investment()
    {
        if (Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            // Admins get all investment
            $investment = Investment::all();
        } else {
            // Other users get only their own created investment
            $investment = Investment::where('created_by', Auth::id())->get();
        }

        return response()->json($investment);
    }

    public function total_investor_amount()
    {
        $invested_amount = DB::table('investments')
        ->whereNotNull('invested_amount')
        ->sum('invested_amount');

        return response()->json([
            'invested_amount' => 'Rs. ' . number_format($invested_amount, 2)
        ]);
    }
















}
