<?php

namespace App\Http\Controllers;

use App\Models\Investor;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class InvestorController extends Controller
{



    public function load_investor(Request $request)
    {
        // $users = User::all();

        // return view('admin.users', compact('users'));

        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $query = DB::table('investors');

        // Role-based filter only admin and super admin see this
        // if (!Auth::user()->hasRole(['Admin', 'Super Admin'])) {
        //     $query->where('investors.saleman_id', Auth::id());
        // }


        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('investors.investor_name', 'like', '%' . $search . '%');
        }



        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $users = $query->get();

   

        $all_data = [];
        foreach ($users as $user) {

            if($user->status == 1){
                $status = '<label class="switch">
                                <input type="checkbox" id="statusToggleSwitch" data-status_id="'.$user->id.'" checked>
                                <span class="slider round"></span>
                            </label>';
            }else if($user->status == 0){
                $status = '<label class="switch">
                                <input type="checkbox" id="statusToggleSwitch" data-status_id="'.$user->id.'">
                                <span class="slider round"></span>
                            </label>';
            }
           

            $btn = '<td class="text-right">';

            // View button
            $btn .= '<a href="' . route("investor_ledger", $user->id) . '" 
            class="btn btn-success btn-icon" data-toggle="tooltip" title="Investor Profit" style="padding: 6px 10px;"><i class="fa-duotone fa-memo" style="margin-right: 3px"></i></a>';

            if (Auth::user()->can('update_investor')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_investor')) {
                $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }
            $btn .= '</td>';

            
            if($user->image != ""){

                $image = '<img   height="50px" src="uploads/investor_image/'.$user->image.'">';

            }else{

                $image = '<img  " height="50px" src="uploads/no_image.png">';

            }

            $all_data[] = [
                'id'                        => $user->id,
                'investor_name'             => $user->investor_name,  
                'phone'                     => $user->phone,
                'email'                     => $user->email,
                'cnic'                      => $user->cnic,
                // 'status'                      => $status,
                'image'                     => $image,
                'btn'                       => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ];

        return response()->json($data);


    }

    public function insert_investor(Request $request)
    {
        $request->validate([
            'phone' => 'required|digits:11',
            'cnic' => 'required|digits:13',
        ]);

        $cnic = Investor::where('investor_name', $request->input('investor_name'))->exists();

        if($cnic){

            return response()->json([
                'status'=> "cnic_Exist",
            ]);

        }else{

            if ($request->hasFile('investor_image')) {
                $image1 = $request->file('investor_image');
                $investor_image = hexdec(uniqid()).'.'.$image1->getClientOriginalExtension();
                $image1->move(public_path('/uploads/investor_image/'), $investor_image);
            } else {
                $investor_image = null; // Set to null if no front image is provided
            }

            $data = new Investor();
            $data->investor_name    = $request->input('investor_name');
            $data->phone             = $request->input('phone');
            $data->email             = $request->input('email');
            $data->cnic              = $request->input('cnic');
            $data->address           = $request->input('address');
            $data->image    = $investor_image;

            $data->created_by       = Auth::id();

            $data->save();

            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function edit_investor($id)
    {

        $data = DB::table('investors')
        ->where('investors.id', $id)
        ->first();

         
        return response()->json([
            'status' => 200,
            'data' => $data, 
        ]);
    }

    public function update_investor(Request $request)
    {
        $request->validate([
            'phone' => 'required|digits:11',
            'cnic' => 'required|digits:13',
        ]);

        $cnic =  Investor::where('cnic', $request->input('cnic'))
        ->where('id', '!=', $request->input('investor_id'))->exists();

        if($cnic){

            return response()->json([
                'status'=> "cnic_Exist",
            ]);

        }else{

            $user = Investor::findOrFail($request->input('investor_id'));
            if ($request->hasFile('investor_image')) {
                // Check and delete old CNIC front image
                if ($user->image && file_exists(public_path('/uploads/investor_image/' . $user->image))) {
                    unlink(public_path('/uploads/investor_image/' . $user->image));
                }

                // Upload the new CNIC front image
                $image1 = $request->file('investor_image');
                $investor_image = hexdec(uniqid()) . '.' . $image1->getClientOriginalExtension();
                $image1->move(public_path('/uploads/investor_image/'), $investor_image);
                $user->investor_image = $investor_image;
            }

            $user->investor_name                 = $request->input('investor_name');
            $user->phone                = $request->input('phone');
            $user->cnic                 = $request->input('cnic');
            $user->email            = $request->input('email');
            $user->address              = $request->input('address');
            $user->updated_by           = Auth::id();

            $user->save();


            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function delete_investor($id)
    {
        $data = Investor::find($id);

        $data->delete();

        return response()->json([
            'status'=>200
        ]);
    }

    public function update_status(Request $request)
    {
        
        $user = Investor::find($request->input('investor_id'));

        $user->status = $request->input('status');

        $user->save();

        return response()->json([
            'status'=>200
        ]);


    }

    public function get_investor()
    {
 
        $investor = Investor::all();
       
        return response()->json($investor);
    }


















    // ledger area 
    public function load_investor_ledger(Request $request)
    {
        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('enddate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");
    
        // Build the query with potential filters
        $query = DB::table('investment_profits')
            ->where('investment_profits.investor_id', '=', $request->input('investor_id'))
            ->join('products', 'investment_profits.pro_id', '=', 'products.id')
            ->select([
            'investment_profits.*', 
            'products.pro_name', 
            'investment_profits.id as id',
        ]);
    
        // dd($query);
    
        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('detail', 'like', '%' . $search . '%');
        }
        $type = $request->input('type');
        if (isset($type)) {
            $query->where('transaction_type', '=', $type);
        }
    
        $totalsQuery = clone $query;
        $totals = $totalsQuery->select([
            DB::raw('SUM(profit_amount) as total_amount'),
            // DB::raw('SUM(credit) as total_credit'),
            // DB::raw('SUM(bank) as total_bank'),
            // DB::raw('SUM(return_amount) as total_return'),
            // DB::raw('SUM(debit) as total_debit')
        ])->first();
    
        // Calculate total before pagination
        $total_count = $query->count();
    
        // Apply sorting and pagination
        // $query->orderBy($order_by, $dir);
        // if ($limit != -1) {
        //     $query->offset($offset)->limit($limit);
        // }
    
        // Fetch the data
        $supplier_ledger = $query->get();
    
        $all_data = [];
        $currentBalance = 0;
    
        foreach ($supplier_ledger as $data) {
          

            // $currentBalance = 0;

            // if ($data->credit > 0) {
            //     $currentBalance += $data->credit;   // only add credit
            // }

            // if ($data->debit > 0) {
            //     $currentBalance += $data->debit;    // only add debit
            // }

            // if ($data->bank > 0) {
            //     $currentBalance += ($data->total - $data->bank); // adjust bank
            // }

            // if ($data->return_amount > 0) {
            //     $currentBalance -= $data->return_amount; // subtract return
            // }

    
            
    
           
    
            $all_data[] = [
                'id'                    => $data->id,
                'date'          => Carbon::parse($data->created_at)->format('d-m-Y'),
                'pro_name'   => $data->pro_name,
                'profit_amount'            => $data->profit_amount,
            ];
        }
    
        $investor_name = Investor::find($request->input('investor_id'));
    
        $total_results = array(
            "total_amount"     => ($totals->total_amount > 0) ? number_format($totals->total_amount, 2) : 0,
        //     "total_debit"     => ($totals->total_debit > 0) ? number_format($totals->total_debit) : 0,
        //     "total_credit"    => ($totals->total_credit > 0) ? number_format($totals->total_credit) : 0,
        //     "total_balance"   => number_format($totals->total_amount - $totals->total_credit - $totals->total_bank - $totals->total_return),
            // 👇 Dono fields bhej do
            
            "investor_name"  => $investor_name->investor_name . " Ledger (ID: " . $investor_name->id . ")",
        );
    
        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
            "totals"          => $total_results,
        ];
    
        return response()->json($data);
    }
    



    // public function insert_customer_payment(Request $request)
    // {
        
    //     // Set credit and debit amounts based on transaction type
    //     $credit = $request->input('transaction_type') == "credit" ? $request->input('amount') : 0;
    //     $debit = $request->input('transaction_type') == "debit" ? $request->input('amount') : 0;
    //     $bank = $request->input('transaction_type') == "bank" ? $request->input('amount') : 0;

    //     if ($request->transaction_type === "credit") {
    //         // hand_cash column
    //         DB::table('hand_cashes')->increment('cash_amount', $request->amount);

    //     } elseif ($request->transaction_type === "bank") {

    //         DB::table('banks')->where('id', $request->bank_id)
    //         ->increment('bank_balance', $request->amount);
    //     }

    
    //     $customer_ledger = new CustomerLedger();
    //     $customer_ledger->cus_id = $request->input('cus_pay_id');
    //     $customer_ledger->invoice_date = Carbon::parse($request->input('transaction_date'))->format('Y-m-d'); // Correct transaction_date field
    //     $customer_ledger->detail = $request->input('transaction_details') ?: "Payment Received"; // Default to "Payment Received"
    //     $customer_ledger->transaction_type = $request->input('transaction_type');
    //     $customer_ledger->bank_id = $request->input('bank_id');

    //     $customer_ledger->credit = $credit;
    //     $customer_ledger->debit = $debit;
    //     $customer_ledger->bank = $bank;

    //     $customer_ledger->created_by = Auth::id();
    //     $customer_ledger->updated_by = Auth::id();
    //     // Save the entry
    //     $customer_ledger->save();
    
    //     return response()->json([
    //         'status' => 200
    //     ]);
    // }


    // public function edit_customer_payment($id)
    // {
    //     // model relation ship
    //     $Data = CustomerLedger::with('bank')->find($id);

    //     if ($Data && $Data->transaction_date) {
    //         $Data->transaction_date = Carbon::parse($Data->transaction_date)->format('d-m-Y');
    //     }
    //     if ($Data) {
    //         $Data->ledger_bank_amount = $Data->bank; // yahan customer_ledgers.bank column
    //     }


    //     return response()->json([
    //         'status' => 200,
    //         'data'   => $Data,
    //     ]);
    // }




    
    // public function update_customer_payment(Request $request)
    // {

    //     if($request->input('transaction_type') == "credit"){

    //         $credit = $request->input('amount');
    //         $debit = 0;
    //         $bank = 0;


    //     }else if($request->input('transaction_type') == "debit"){

    //         $credit = 0;
    //         $bank = 0;
    //         $debit = $request->input('amount');
    //     }
    //     else if($request->input('transaction_type') == "bank"){

    //         $credit = 0;
    //         $debit = 0;
    //         $bank = $request->input('amount');
    //     }

        
    //     if ($request->transaction_type === "credit") {
    //         // hand_cash column
    //         DB::table('hand_cashes')->increment('cash_amount', $request->amount);

    //     } elseif ($request->transaction_type === "bank") {

    //         DB::table('banks')->where('id', $request->bank_id)
    //         ->increment('bank_balance', $request->amount);
    //     }
 
    //     $customer_ledger                = CustomerLedger::find($request->input('pay_id'));
    //     $customer_ledger->invoice_date  = Carbon::parse($request->input('transaction_date'))->format('Y-m-d');
    //     $customer_ledger->detail        = ($request->input('transaction_details') != "")?$request->input('transaction_details'):"Payment";
    //     $customer_ledger->credit        = $credit;
    //     $customer_ledger->debit         = $debit;
    //     $customer_ledger->bank          = $bank;

    //     $customer_ledger->updated_by       = Auth::id();

    //     $customer_ledger->save();

    //     return response()->json([
    //         'status'=>200
    //     ]);

    // }


    // public function delete_customer_payment($delete_id)
    // {
    //     $payment = CustomerLedger::find($delete_id)->delete();

    //     return response()->json([
    //         'status'=>200
    //     ]);
    // }






}
