<?php

namespace App\Http\Controllers;

use App\Models\OrderReturn;
use App\Models\OrderReturnDetail;
use App\Models\SalemanStock;
use App\Models\Stock;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class OrderReturnController extends Controller
{
    

    public function load_order_return(Request $request)
    {
        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('enddate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $user = Auth::user();

        $query = DB::table('order_returns')
        ->leftJoin('customers', 'order_returns.customer_id', '=', 'customers.id')
        ->leftJoin('users', 'order_returns.salesman_id', '=', 'users.id')
        ->select(
            'order_returns.*',
            'customers.name as customer_name',
            'users.name as salesman_name'
        );

        // Role-based filter
        if (!Auth::user()->hasRole(['Admin', 'Super Admin', 'Store man'])) {
            $query->where('order_returns.salesman_id', Auth::id());
        }




        // ✅ Date filtering
        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('order_returns.created_at', [$start_date, $end_date]);
        }

        // ✅ Search filter (optional)
        if ($search = $request->input('search')) {
            $query->where(function ($q) use ($search) {
                $q->where('order_returns.total_amount', 'like', "%$search%")
                ->orWhere('customers.name', 'like', "%$search%")
                ->orWhere('users.name', 'like', "%$search%");
            });
        }

        // ✅ Total count
        $total_count = $query->count();

        // ✅ Sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        $users = $query->get();

        $all_data = [];
        foreach ($users as $user) {
            $btn = '<td class="text-right">';
            // if (Auth::user()->can('view_orders')) {
            //     $btn .= '<button id="view_btn" data-vid="'.$user->id.'" class="btn btn-success btn-icon btn-sm" data-toggle="tooltip" title="View" style="margin-right: 3px"><i class="fa-duotone fa-arrows-to-eye"></i></button>';
            // }
            if (Auth::user()->can('update_order_return')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_order_return')) {
                $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }

            $btn .= '</td>';


            if ($user->status == "pending"){
                                
                $status = '<div class="label label-table label-warning">Pending</div>';   
            }else {
                $status = '<div class="label label-table label-success">Approved</div>';
            }

            $all_data[] = [
                'id'            => $user->id,
                'salesman_id'   => $user->salesman_name,
                'description'   => $user->description,
                'status'        => $status,
                'btn'           => $btn
            ];
        }

        return response()->json([
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ]);
    }

    public function insert_order_return(Request $request)
    {


        $order = new OrderReturn();
        $order->date             = $request->input('date');
        $order->salesman_id         = $request->input('salesman_id') ? $request->input('salesman_id') : Auth::id();
        $order->description         = $request->input('description');
        $order->created_by          = Auth::id();
        $order->save();


        // Extract customer  ledger data
        $products       = implode(",", $request->input('pro_id'));
        $pro_qty1       = implode(",", $request->input('pro_qty'));

        // Get the last inserted Book Test ID
        $order_return_id = $order->id;
        // Extract data from the request
        $pro_ids        = $request->input('pro_id');
        // $pro_price      = $request->input('pro_price');
        $pro_qty        = $request->input('pro_qty');
        // $total          = $request->input('total');

        // Loop through the data and save each entry
        foreach ($pro_ids as $index => $pro_id) {
            $order_detail                   = new OrderReturnDetail();
            $order_detail->order_return_id         = $order_return_id;
            $order_detail->product_id       = $pro_id;
            // $order_detail->pro_price       = $pro_price[$index];
            $order_detail->quantity         = $pro_qty[$index];
            // $order_detail->total            = $total[$index];
            $order_detail->save();


        }

        return response()->json([
            'status'=>200
        ]);

        
    }


    public function edit_order_return($id)
    {
        $data = DB::table('order_returns')
            ->leftJoin('customers', 'order_returns.customer_id', '=', 'customers.id')
            ->leftJoin('users', 'order_returns.salesman_id', '=', 'users.id')
            ->select(
                'order_returns.*',
                'customers.name as customer_name',
                'users.name as salesman_name'
            )
            ->where('order_returns.id', $id)
            ->first();

        $order_details = DB::table('order_return_details')
        ->join('products', 'order_return_details.product_id', '=', 'products.id')
        ->select(
            'order_return_details.*',
            'products.pro_name',
            'products.id as pro_id'
        )
        ->where('order_return_details.order_return_id', $id)
        ->get();

        // foreach ($order_details as $detail) {
        //     $stock = DB::table('saleman_stocks')
        //         ->selectRaw('SUM(stock_in_qty) as stock_in_qty, SUM(stock_out_qty) as stock_out_qty')
        //         ->where('pro_id', '=', $detail->pro_id)
        //         ->first();

        //     $detail->pro_stock = ($stock->stock_in_qty ?? 0) - ($stock->stock_out_qty ?? 0);
        // }

        if (!$data) {
            return response()->json([
                'status' => 404,
                'message' => 'Order not found.',
            ]);
        }

        return response()->json([
            'status' => 200,
            'data' => $data,
            'order_details' => $order_details,
        ]);
    }


    public function update_order_return(Request $request)
    {
        // Find the record by ID
        $order = OrderReturn::find($request->input('order_return_id'));

        // dd($order);

        if (!$order) {
            return response()->json(['status' => 404, 'message' => 'Order not found.']);
        }

        // Update the main  record
        
        $order->date         = $request->input('date');
        $order->salesman_id         = $request->input('salesman_id');
        $order->description         = $request->input('description');
        $order->status              = $request->input('order_status');
        $order->updated_by          = Auth::id(); 
        $order->save();
        $order_return_id = $order->id;

        // Delete old order details for this
        OrderReturnDetail::where('order_return_id', $order_return_id)->delete();
        Stock::where('order_return_id', $order_return_id)->delete();
        SalemanStock::where('order_return_id', $order_return_id)->delete();


        // Reinsert the sale details
        $pro_ids = $request->input('pro_id'); 
        $pro_qty = $request->input('pro_qty'); 

        foreach ($pro_ids as $index => $pro_id) {
            $order_detail                      = new OrderReturnDetail();
            $order_detail->order_return_id     = $order_return_id;
            $order_detail->product_id          = $pro_id; 
            $order_detail->quantity            = $pro_qty[$index]; 
            $order_detail->save();

            // Manage stock
            $stock                              = new Stock();
            $stock->order_return_id             = $order_return_id;
            $stock->pro_id                      = $pro_id;
            $stock->salesman_id                 = $request->input('salesman_id');
            $stock->adjustment                  = 'Order Return';

            $stock->stock_in_qty               = $pro_qty[$index];
            $stock->save();

            // saleman stock
            $saleman_stock                              = new SalemanStock();
            $saleman_stock->order_return_id             = $order_return_id;
            $saleman_stock->pro_id                      = $pro_id;
            $saleman_stock->salesman_id                 = $request->input('salesman_id');
            $saleman_stock->adjustment                  = 'Order Return';
            $saleman_stock->stock_out_qty               = $pro_qty[$index];
            $saleman_stock->save();

        }


        

        return response()->json(['status' => 200, 'message' => 'Order updated successfully.']);
    }


    public function delete_order_return($id)
    {
        $order = OrderReturn::find($id);

        if (!$order) {
            return response()->json([
                'status' => 404,
                'message' => 'Order return not found.'
            ]);
        }

        // Delete order details first
        $order->orderReturnDetails()->delete();
        $order->stocks()->delete();
        $order->salemanStocks()->delete();


        // Delete the order
        $order->delete();

        return response()->json([
            'status' => 200,
            'message' => 'Order and its details deleted successfully.'
        ]);
    }

  
    public function get_order_return()
    {
        $user = Auth::user();

        // اگر user کا رول admin یا super_admin نہیں ہے تو filter لگا دو
        if (!$user->hasRole(['Admin', 'Super Admin'])) {
            $orders = OrderReturn::where('salesman_id', $user->id)->get();
        } else {
            // admin اور super admin کے لیے سب orders
            $orders = OrderReturn::all();
        }

        return response()->json($orders);
    }



    // public function view_order_return($id)
    // {
    //     $order = DB::table('orders')
    //         ->leftJoin('customers', 'orders.customer_id', '=', 'customers.id')
    //         ->leftJoin('users', 'orders.salesman_id', '=', 'users.id')

    //         ->select(
    //             'orders.*',
    //             'customers.name as cus_name', 
    //             'users.name as salesman_name', 

    //             'orders.id as id'
    //         )
    //         ->where('orders.id', $id)
    //         ->first();

    //     if (!$order) {
    //         return response()->json([
    //             'status' => 404,
    //             'message' => 'Order not found'
    //         ], 404);
    //     }

    
    //     $order_details = DB::table('order_details')
    //     ->select('*')->where('order_id', '=', $id)
    //     ->get();

    //     $products = [];

    //     foreach($order_details as $index => $pros) {
    //         $pro = DB::table('products')->select('*')
    //             ->where('id', '=', $pros->product_id)->first(); // ✅ correct property name

    //         $products[] = [
    //             'no'         => $index + 1,
    //             'pro_id'     => $pro->id ?? null,
    //             'pro_name'   => $pro->pro_name ?? 'Unknown Product',
    //             'pro_price'  => $pros->pro_price,
    //             'pro_qty'    => $pros->quantity,
    //             'total'      => $pros->total,
    //         ];
    //     }


    //     return response()->json([
    //         'status' => 200,
    //         'order' => $order,
    //         'products' => $products, 
    //     ]);
    // }



}
