<?php

namespace App\Http\Controllers;

use App\Models\Prodcut;
use App\Models\Product;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ProductController extends Controller
{


    public function load_products(Request $request)
    {
        // $users = User::all();

        // return view('admin.users', compact('users'));

        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        $query = DB::table('products')
            ->leftJoin(
                DB::raw('(SELECT pro_id, single_price, sale_price, id FROM purchase_details pd1 WHERE id = (SELECT MAX(id) FROM purchase_details pd2 WHERE pd2.pro_id = pd1.pro_id)) as latest_purchase'),
                'products.id',
                '=',
                'latest_purchase.pro_id'
            )
            ->select(
                'products.*',
                DB::raw('COALESCE(latest_purchase.single_price, products.purchase_price, 0) as purchase_price'),
                DB::raw('COALESCE(latest_purchase.sale_price, products.sale_price, 0) as sale_price')
            );

        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('products.created_at', [$start_date, $end_date]);
        }

        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('products.pro_name', 'like', '%' . $search . '%');
        }



        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $users = $query->get();



        $all_data = [];
        foreach ($users as $user) {



            $btn = '<td class="text-right">';
            if (Auth::user()->can('update_product')) {
                $btn .= '<button id="edit_btn" data-eid="'.$user->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_product')) {
                $btn .= '<button id="delete_btn" data-did="'.$user->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }
            $btn .= '</td>';





            $all_data[] = [
                'id'            => $user->id,
                'pro_name'          => $user->pro_name,
                'purchase_price'         => $user->purchase_price,
                'sale_price'          => $user->sale_price,
                'description'          => $user->description,

                'btn'           => $btn
            ];
        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data,
        ];

        return response()->json($data);


    }

  

    public function insert_product(Request $request)
    {

        $sku = 'PRD-' . strtoupper(substr($request->pro_name, 0, 3)) . '-' . time();

        $data = new Product();
        $data->pro_name         = $request->input('pro_name');
        // Purchase and sale prices are now set to 0, will be fetched from purchase_details
        $data->purchase_price        = 0;
        $data->sale_price        = 0;
        $data->cat_id        = $request->input('cat_id');
        $data->unit_id        = $request->input('unit_id');

        $data->description        = $request->input('description');
        $data->purchase_price_dollar        = 0;
        $data->show_to_salesman        = $request->input('show_to_salesman') ? 1 : 0;



        $data->sku        = $sku;

        $data->created_by   = Auth::id();

        $data->save();

        return response()->json([
            'status'=>200
        ]);
    }


    public function edit_product($id)
    {
        // Fetch product details with latest purchase prices
        $data = DB::table('products')
        ->leftJoin('categories', 'products.cat_id', '=', 'categories.id')
        ->leftJoin('units', 'products.unit_id', '=', 'units.id')
        ->leftJoin(
            DB::raw('(SELECT pro_id, single_price, sale_price, id FROM purchase_details pd1 WHERE id = (SELECT MAX(id) FROM purchase_details pd2 WHERE pd2.pro_id = pd1.pro_id)) as latest_purchase'),
            'products.id',
            '=',
            'latest_purchase.pro_id'
        )
        ->select(
            'products.*',
            'categories.cat_name',
            'units.unit_name',
            DB::raw('COALESCE(latest_purchase.single_price, products.purchase_price, 0) as purchase_price'),
            DB::raw('COALESCE(latest_purchase.sale_price, products.sale_price, 0) as sale_price')
        )
        ->where('products.id', $id)
        ->first();


        $totals = DB::table('stocks')
        ->select([
            DB::raw('SUM(stock_in_qty) as stock_in_qty'),
            DB::raw('SUM(stock_out_qty) as stock_out_qty')
        ])
        ->where('pro_id', '=', $id)
        ->first();

        return response()->json([
            'data' => $data,
            // 'total_cost' => $product->cost_price,
            'total_qty'  => $totals->stock_in_qty - $totals->stock_out_qty,
        ]);
    }


    public function edit_saleman_product($id, Request $request)
    {
        $salesman_id = $request->input('salesman_id') ? $request->input('salesman_id') : Auth::id(); // Current logged-in saleman
        $cus_id = $request->input('cus_id');


        // Fetch product details
        $data = DB::table('products')
            ->leftJoin('categories', 'products.cat_id', '=', 'categories.id')
            ->leftJoin('units', 'products.unit_id', '=', 'units.id')
            ->select(
                'products.*',
                'categories.cat_name',
                'units.unit_name'
            )
            ->where('products.id', $id)
            ->first();

        // Only current saleman's stock
        $totals = DB::table('saleman_stocks')
        ->select([
            DB::raw('SUM(stock_in_qty) as stock_in_qty'),
            DB::raw('SUM(stock_out_qty) as stock_out_qty')
        ])
        ->where('pro_id', '=', $id)
        ->where('salesman_id', '=', $salesman_id) // Filter by logged-in saleman
        ->first();

           
            
        $totalSoldQty = DB::table('sales')
        ->join('sale_details', 'sales.id', '=', 'sale_details.sale_id')
        ->where('sales.cus_id', $cus_id)         
        ->where('sales.saleman_id', $salesman_id) 
        ->where('sale_details.pro_id', $id)       
        ->sum('sale_details.pro_qty');
        // total qty


        return response()->json([
            'data' => $data,
            'total_qty'  => ($totals->stock_in_qty ?? 0) - ($totals->stock_out_qty ?? 0),
            'total_sold_qty' => $totalSoldQty 
        ]);
    }
        

    public function update_product(Request $request)
    {
        $product =  Product::where('pro_name', $request->input('pro_name'))
        ->where('id', '!=', $request->input('pro_id'))->exists();

        if($product){

            return response()->json([
                'status'=> "pro_Exist",
            ]);

        }else{

            $data = Product::findOrFail($request->input('pro_id'));
            $data->pro_name         = $request->input('pro_name');
            // Purchase and sale prices are now managed through purchase_details, keep existing values
            // $data->purchase_price        = $request->input('purchase_price');
            // $data->sale_price        = $request->input('sale_price');
            $data->cat_id        = $request->input('cat_id');
            $data->unit_id        = $request->input('unit_id');

            $data->description        = $request->input('description');
            // $data->purchase_price_dollar        = $request->input('purchase_price_dollar');
            $data->show_to_salesman        = $request->input('show_to_salesman') ? 1 : 0;


            $data->updated_by   = Auth::id();
            $data->save();


            return response()->json([
                'status'=>200
            ]);

        }
    }

    public function delete_product($id)
    {
        $data = Product::find($id);

        $data->delete();

        return response()->json([
            'status'=>200
        ]);
    }

    
    public function get_products()
    {
        // Check if user is Admin or Super Admin
        if (Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            // Admins see all products with latest prices from purchase_details
            $products = DB::table('products')
                ->leftJoin(
                    DB::raw('(SELECT pro_id, single_price, sale_price, id FROM purchase_details pd1 WHERE id = (SELECT MAX(id) FROM purchase_details pd2 WHERE pd2.pro_id = pd1.pro_id)) as latest_purchase'),
                    'products.id',
                    '=',
                    'latest_purchase.pro_id'
                )
                ->select(
                    'products.*',
                    DB::raw('COALESCE(latest_purchase.single_price, products.purchase_price, 0) as purchase_price'),
                    DB::raw('COALESCE(latest_purchase.sale_price, products.sale_price, 0) as sale_price')
                )
                ->get();
        } else {
            // Salesmen and Order Bookers only see products where show_to_salesman = 1
            $products = DB::table('products')
                ->leftJoin(
                    DB::raw('(SELECT pro_id, single_price, sale_price, id FROM purchase_details pd1 WHERE id = (SELECT MAX(id) FROM purchase_details pd2 WHERE pd2.pro_id = pd1.pro_id)) as latest_purchase'),
                    'products.id',
                    '=',
                    'latest_purchase.pro_id'
                )
                ->where('products.show_to_salesman', 1)
                ->select(
                    'products.*',
                    DB::raw('COALESCE(latest_purchase.single_price, products.purchase_price, 0) as purchase_price'),
                    DB::raw('COALESCE(latest_purchase.sale_price, products.sale_price, 0) as sale_price')
                )
                ->get();
        }

        return response()->json($products);
    }

    public function get_products_excluding_sdk_cdk()
    {
        // Get products excluding SDK and CDK categories with latest prices
        $query = DB::table('products')
            ->leftJoin('categories', 'products.cat_id', '=', 'categories.id')
            ->leftJoin(
                DB::raw('(SELECT pro_id, single_price, sale_price, id FROM purchase_details pd1 WHERE id = (SELECT MAX(id) FROM purchase_details pd2 WHERE pd2.pro_id = pd1.pro_id)) as latest_purchase'),
                'products.id',
                '=',
                'latest_purchase.pro_id'
            )
            ->where(function($query) {
                $query->where(function($q) {
                    // Exclude SDK and CDK categories
                    $q->where('categories.cat_name', '!=', 'SDK')
                      ->where('categories.cat_name', '!=', 'CDK');
                })
                ->orWhereNull('categories.cat_name'); // Include products without category
            });

        // If user is not Admin or Super Admin, filter by show_to_salesman
        if (!Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            $query->where('products.show_to_salesman', 1);
        }

        $products = $query->select(
                'products.*',
                DB::raw('COALESCE(latest_purchase.single_price, products.purchase_price, 0) as purchase_price'),
                DB::raw('COALESCE(latest_purchase.sale_price, products.sale_price, 0) as sale_price')
            )
            ->distinct()
            ->get();

        return response()->json($products);
    }


}
