<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TransactionController extends Controller
{



    public function load_cash_bank_report(Request $request)
    {
        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        // Build the query with potential filters
        $query = DB::table('transactions') 
        ->leftJoin('banks', 'transactions.bank_id', '=', 'banks.id')

        ->select([
            'transactions.*',  
            'banks.bank_name', 

            'transactions.id as id',
        ]);

        // Role-based filter
        if (!Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            $query->where('transactions.created_by', Auth::id());
        }

        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('transactions.created_at', [$start_date, $end_date]);
        }


        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('banks.bank_name', 'like', '%' . $search . '%');
        }
       

        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $sale = $query->get();

        $all_data = [];
        foreach ($sale as $data) {
 

            $all_data[] = [
                'id'            => $data->id,
                'payment_type'  => $data->payment_type,
                'bank_name'     => $data->bank_name ?? '---',
                'amount'        => number_format($data->amount, 2), // 2 decimals e.g. 2,000.00
                'transaction_type'  => $data->transaction_type,
                'source_type'  => $data->source_type,
                'description'     => $data->description ?? '---', // null check
                'date'          => Carbon::parse($data->created_at)->format('d-m-Y'), 
            ];

        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data
        ];

        return response()->json($data);
    }


}
