<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class WithdrawalController extends Controller
{
    
    
    public function load_withdrawals(Request $request)
    {
        $start_date = !empty($request->input('startdate')) ? Carbon::parse($request->input('startdate'))->format('Y-m-d') : "";
        $end_date   = !empty($request->input('startdate')) ? Carbon::parse($request->input('enddate'))->format('Y-m-d') : "";
        $limit      = $request->input('length');
        $offset     = $request->input('start');
        $column     = $request->input('order.0.column');
        $dir        = $request->input('order.0.dir');
        $order_by   = $request->input("columns.$column.data");

        // Build the query with potential filters
        $query = DB::table('investment_withdraws')
        ->leftJoin('investors', 'investment_withdraws.investor_id', '=', 'investors.id')
        ->leftJoin('banks', 'investment_withdraws.bank_id', '=', 'banks.id')

        ->select([
            'investment_withdraws.*', 
            'investors.investor_name', 
            'banks.bank_name', 

            'investment_withdraws.id as id',
        ]);

        // Role-based filter
        if (!Auth::user()->hasRole(['Admin', 'Super Admin'])) {
            $query->where('investment_withdraws.created_by', Auth::id());
        }

        if (!empty($start_date) && !empty($end_date)) {
            $query->whereBetween('investment_withdraws.date', [$start_date, $end_date]);
        }


        if ($search = $request->input('search')) { // .value if using DataTables
            $query->where('investors.name', 'like', '%' . $search . '%');
        }
       

        // Calculate total before pagination
        $total_count = $query->count();

        // Apply sorting and pagination
        $query->orderBy($order_by, $dir);
        if ($limit != -1) {
            $query->offset($offset)->limit($limit);
        }

        // Fetch the data
        $sale = $query->get();

        $all_data = [];
        foreach ($sale as $data) {


            $btn = '<td class="text-right">';
         
            if (Auth::user()->can('update_withdrawal')) {
                $btn .= '<button id="edit_btn" data-eid="'.$data->id.'" class="btn btn-info btn-icon" data-toggle="tooltip" title="Edit" style="margin-right: 3px"><i class="fa-duotone fa-pen-to-square"></i></button>';
            }
            if (Auth::user()->can('delete_withdrawal')) {
                $btn .= '<button id="delete_btn" data-did="'.$data->id.'" class="btn btn-danger btn-icon" data-toggle="tooltip" title="Delete" style="padding: 6px 10px;"><i class="fa-duotone fa-trash-xmark"></i></button>';
            }
            $btn .= '</td>';

            $all_data[] = [
                'id'            => $data->id,
                'type'          => $data->type,
                'investor_name' => $data->investor_name ?? 'Company',
                'amount'        => number_format($data->amount, 2), // 2 decimals e.g. 2,000.00
                'payment_type'  => $data->payment_type,
                'bank_name'     => $data->bank_name ?? '---', // null check
                'date'          => Carbon::parse($data->date)->format('d-m-Y'),
                // 'btn'           => $btn
            ];

        };

        $data = [
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $total_count,
            "recordsFiltered" => $total_count,
            "data"            => $all_data
        ];

        return response()->json($data);
    }


    // public function insert_withdrawals(Request $request)
    // {
    //     $date            = $request->input('date');
    //     $type            = $request->input('withdraw_type'); // "Investor" or "Company"
    //     $investor_id     = $request->input('investor_id');
    //     $withdraw_amount = $request->input('amount');
    //     $payment_type    = $request->input('payment_type'); 
    //     $bank_id         = $request->input('bank_id');

    //     // 1️⃣ Investor Withdrawal
    //     if ($type === "Investor") {
    //         $totalInvestment = DB::table('investments')
    //             ->where('investor_id', $investor_id)
    //             ->sum('invested_amount');

    //         $totalProfit = DB::table('investment_profits')
    //             ->where('investor_id', $investor_id)
    //             ->sum('profit_amount');

    //         $totalWithdrawn = DB::table('investment_withdraws')
    //             ->where('investor_id', $investor_id)
    //             ->where('type', 'Investor')
    //             ->sum('amount');

    //         $availableBalance = ($totalInvestment + $totalProfit) - $totalWithdrawn;

    //         if ($withdraw_amount > $availableBalance) {
    //             return response()->json([
    //                 'status'  => 400,
    //                 'message' => 'Not enough balance to withdraw (Investment + Profit).'
    //             ]);
    //         }
    //     }

    //     // 2️⃣ Company Withdrawal
    //     if ($type === "Company") {
    //         $companyProfit = DB::table('company_investments')->sum('invested_amount');
    //         $companyWithdrawn = DB::table('investment_withdraws')
    //             ->where('type', 'Company')
    //             ->sum('amount');

    //         $availableBalance = $companyProfit - $companyWithdrawn;

    //         if ($withdraw_amount > $availableBalance) {
    //             return response()->json([
    //                 'status'  => 400,
    //                 'message' => 'Not enough company balance to withdraw.'
    //             ]);
    //         }
    //     }

    //     // 3️⃣ Save withdrawal first
    //     $withdrawId = DB::table('investment_withdraws')->insertGetId([
    //         'type'        => $type,
    //         'investor_id' => $type === "Investor" ? $investor_id : null,
    //         'amount'      => $withdraw_amount,
    //         'payment_type'=> $payment_type,
    //         'bank_id'     => $bank_id,
    //         'date'        => $date,
    //         'created_by'  => Auth::id(),
    //         'created_at'  => now(),
    //     ]);

    //     // 4️⃣ Adjust payment & create transaction
    //     if ($payment_type === "Cash") {
    //         DB::table('hand_cashes')->decrement('cash_amount', $withdraw_amount);

    //         DB::table('transactions')->insert([
    //             'payment_type'     => 'Cash',
    //             'amount'           => $withdraw_amount,
    //             'transaction_type' => 'withdraw',
    //             'source_type'      => $type === "Investor" ? 'Investor Withdrawal' : 'Company Withdrawal',
    //             'source_id'        => $withdrawId,
    //             'description'      => $type . ' Withdrawal',
    //             'created_at'       => now(),
    //         ]);

    //     } elseif ($payment_type === "Bank" && $bank_id) {
    //         DB::table('banks')->where('id', $bank_id)->decrement('bank_balance', $withdraw_amount);

    //         DB::table('transactions')->insert([
    //             'payment_type'     => 'Bank',
    //             'bank_id'          => $bank_id,
    //             'amount'           => $withdraw_amount,
    //             'transaction_type' => 'withdraw',
    //             'source_type'      => $type === "Investor" ? 'Investor Withdrawal' : 'Company Withdrawal',
    //             'source_id'        => $withdrawId,
    //             'description'      => $type . ' Withdrawal',
    //             'created_at'       => now(),
    //         ]);
    //     }

    //     return response()->json(['status' => 200, 'message' => 'Withdrawal successful']);
    // }
    public function insert_withdrawals(Request $request)
    {
        $date            = $request->input('date');
        $type            = $request->input('withdraw_type'); // "Investor" or "Company"
        $investor_id     = $request->input('investor_id');
        $withdraw_amount = $request->input('amount');
        $payment_type    = $request->input('payment_type'); 
        $bank_id         = $request->input('bank_id');

        // 🔹 Direct save withdrawal (No balance check)
        $withdrawId = DB::table('investment_withdraws')->insertGetId([
            'type'        => $type,
            'investor_id' => $type === "Investor" ? $investor_id : null,
            'amount'      => $withdraw_amount,
            'payment_type'=> $payment_type,
            'bank_id'     => $bank_id,
            'date'        => $date,
            'created_by'  => Auth::id(),
            'created_at'  => now(),
        ]);

        // 🔹 Adjust payment & create transaction
        if ($payment_type === "Cash") {
            DB::table('hand_cashes')->decrement('cash_amount', $withdraw_amount);

            DB::table('transactions')->insert([
                'payment_type'     => 'Cash',
                'amount'           => $withdraw_amount,
                'transaction_type' => 'withdraw',
                'source_type'      => $type === "Investor" ? 'Investor Withdrawal' : 'Company Withdrawal',
                'source_id'        => $withdrawId,
                'description'      => $type . ' Withdrawal',
                'created_at'       => now(),
            ]);

        } elseif ($payment_type === "Bank" && $bank_id) {
            DB::table('banks')->where('id', $bank_id)->decrement('bank_balance', $withdraw_amount);

            DB::table('transactions')->insert([
                'payment_type'     => 'Bank',
                'bank_id'          => $bank_id,
                'amount'           => $withdraw_amount,
                'transaction_type' => 'withdraw',
                'source_type'      => $type === "Investor" ? 'Investor Withdrawal' : 'Company Withdrawal',
                'source_id'        => $withdrawId,
                'description'      => $type . ' Withdrawal',
                'created_at'       => now(),
            ]);
        }

        return response()->json(['status' => 200, 'message' => 'Withdrawal successful']);
    }






}
