<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckDomain
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
   

    public function handle(Request $request, Closure $next)
    {
        $allowedDomain = env('APP_DOMAIN');
        if ($allowedDomain && $request->getHost() !== $allowedDomain) {
            // abort(403, 'This application is licensed only for '.$allowedDomain);
            abort(403, 'This application is licensed only for use on '.$allowedDomain.'. Please contact the administrator Or any Software Engineer if you believe this is an error.');

        }

        return $next($request);
    }

}
