<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    use HasFactory;

    protected $fillable = [
        'exp_date',
        'exp_detail',
        'total_amt',
        'is_active',
        'is_deleted',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'exp_date' => 'date',
        'total_amt' => 'decimal:2',
        'is_active' => 'integer',
        'is_deleted' => 'integer',
    ];

    // Relationships
    public function expenseDetails()
    {
        return $this->hasMany(ExpenseDetail::class, 'exp_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
