<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    public function invoiceDetails()
    {
        return $this->hasMany(InvoiceDetail::class, 'invoice_id', 'id');
    }

    public function salemanStock()
    {
        return $this->hasMany(SalemanStock::class, 'invoice_id', 'id');
    }

    public function customerLedger()
    {
        return $this->hasMany(CustomerLedger::class, 'invoice_id', 'id');
    }
    public function salemanLedger()
    {
        return $this->hasMany(SalemanLedger::class, 'invoice_id', 'id');
    }
    public function investorLedger()
    {
        return $this->hasMany(InvestmentProfit::class, 'invoice_id', 'id');
    }
}
