<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderBooker extends Model
{
    use HasFactory;

    public function orderBookerDetails()
    {
        return $this->hasMany(OrderBookerDetail::class, 'order_booker_id', 'id');
    }

    public function salemanStock()
    {
        return $this->hasMany(SalemanStock::class, 'order_booker_id', 'id');
    }

    public function customerLedger()
    {
        return $this->hasMany(CustomerLedger::class, 'order_booker_id', 'id');
    }
    public function salemanLedger()
    {
        return $this->hasMany(SalemanLedger::class, 'order_booker_id', 'id');
    }
    public function investorLedger()
    {
        return $this->hasMany(InvestmentProfit::class, 'order_booker_id', 'id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'cus_id', 'id');
    }

    public function salesman()
    {
        return $this->belongsTo(User::class, 'saleman_id', 'id');
    }
}
