<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderBookerLedger extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'order_booker_id',
        'created_by_user',
        'invoice_date',
        'detail',
        'transaction_type',
        'bank_id',
        'order_amount',
        'paid_amount',
        'expense_amount',
        'status',
        'received_at',
        'received_by',
        'approved_at',
        'approved_by'
    ];

    protected $casts = [
        'invoice_date' => 'date',
        'order_amount' => 'decimal:2',
        'paid_amount' => 'decimal:2',
        'expense_amount' => 'decimal:2',
        'received_at' => 'datetime',
        'approved_at' => 'datetime',
    ];

    // Relationships
    public function orderBooker()
    {
        return $this->belongsTo(OrderBooker::class, 'order_booker_id');
    }

    public function createdByUser()
    {
        return $this->belongsTo(User::class, 'created_by_user');
    }

    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_id');
    }

    public function receivedByUser()
    {
        return $this->belongsTo(User::class, 'received_by');
    }

    public function approvedByUser()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    // Scopes
    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeReceived($query)
    {
        return $query->where('status', 'received');
    }

    public function scopeApproved($query)
    {
        return $query->where('status', 'approved');
    }
}
