<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    /**
     * Relationship to purchase details
     */
    public function purchaseDetails()
    {
        return $this->hasMany(PurchaseDetail::class, 'pro_id', 'id');
    }

    /**
     * Get the latest purchase detail for this product
     */
    public function latestPurchaseDetail()
    {
        return $this->hasOne(PurchaseDetail::class, 'pro_id', 'id')->latest();
    }

    /**
     * Get purchase price from the latest purchase
     */
    public function getPurchasePriceAttribute($value)
    {
        // If there's a value in the products table, return it (for backward compatibility)
        if ($value !== null && $value > 0) {
            return $value;
        }

        // Otherwise, fetch from the latest purchase detail
        $latestPurchase = $this->latestPurchaseDetail;
        return $latestPurchase ? $latestPurchase->purchase_price : 0;
    }

    /**
     * Get sale price from the latest purchase
     */
    public function getSalePriceAttribute($value)
    {
        // If there's a value in the products table, return it (for backward compatibility)
        if ($value !== null && $value > 0) {
            return $value;
        }

        // Otherwise, fetch from the latest purchase detail
        $latestPurchase = $this->latestPurchaseDetail;
        return $latestPurchase ? $latestPurchase->sale_price : 0;
    }
}
