<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseReturn extends Model
{
    use HasFactory;

    protected $fillable = [
        'supplier_id',
        'purchase_id',
        'return_date',
        'payment_type',
        'bank_id',
        'detail',
        'subtotal',
        'grand_total',
        'refund_amount',
        'adjustment_amount',
        'status',
        'created_by',
        'updated_by',
    ];

    /**
     * Get the supplier for this purchase return.
     */
    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'supplier_id');
    }

    /**
     * Get the purchase return details.
     */
    public function purchaseReturnDetails()
    {
        return $this->hasMany(PurchaseReturnDetail::class, 'purchase_return_id');
    }

    /**
     * Get the supplier ledger entries for this purchase return.
     */
    public function supplierLedger()
    {
        return $this->hasMany(SupplierLedger::class, 'purchase_return_id');
    }

    /**
     * Get the stock entries for this purchase return.
     */
    public function stock()
    {
        return $this->hasMany(Stock::class, 'purchase_return_id');
    }

    /**
     * Get the bank for this purchase return.
     */
    public function bank()
    {
        return $this->belongsTo(Bank::class, 'bank_id');
    }

    /**
     * Get the user who created this purchase return.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the user who last updated this purchase return.
     */
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
