<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sale extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function saleDetails()
    {
        return $this->hasMany(SaleDetail::class, 'sale_id', 'id');
    }

    public function salemanStock()
    {
        return $this->hasMany(SalemanStock::class, 'sale_id', 'id');
    }

    public function customerLedger()
    {
        return $this->hasMany(CustomerLedger::class, 'sale_id', 'id');
    }
    public function salemanLedger()
    {
        return $this->hasMany(SalemanLedger::class, 'sale_id', 'id');
    }
    public function investorLedger()
    {
        return $this->hasMany(InvestmentProfit::class, 'sale_id', 'id');
    }
    public function stock()
    {
        return $this->hasMany(Stock::class, 'sale_id', 'id');
    }
}
