<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleReturn extends Model
{
    use HasFactory;

    public function saleReturnDetails()
    {
        return $this->hasMany(SaleReturnDetail::class, 'sale_return_id', 'id');
    }

    public function stock()
    {
        return $this->hasMany(Stock::class, 'sale_return_id', 'id');
    }
     public function nonServiceStock()
    {
        return $this->hasMany(NonServiceStock::class, 'sale_return_id', 'id');
    }

    public function customerLedger()
    {
        return $this->hasMany(CustomerLedger::class, 'sale_return_id', 'id');
    }
    public function salemanLedger()
    {
        return $this->hasMany(SalemanLedger::class, 'sale_return_id', 'id');
    }
}
