<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('supplier_id')->nullable();
            $table->string('date')->nullable();
            $table->string('pur_detail')->nullable();
            $table->decimal('sub_total', 10, 2);
            $table->decimal('tax_amount', 10, 2);
            $table->decimal('paid_amount', 10,2)->nullable();
            $table->decimal('remain_amount', 10,2)->nullable();
            $table->decimal('grand_total', 10,2)->nullable();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchases');
    }
};
