<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_ledgers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('supplier_id')->nullable();
            $table->bigInteger('purchase_id')->nullable();
            $table->bigInteger('pur_return_id')->nullable();
            $table->bigInteger('pro_id')->nullable();
            $table->date('date')->nullable();
            $table->string('detail')->nullable();
            $table->integer('pro_qty')->nullable();
            $table->decimal('pay', 10, 2)->nullable();
            $table->decimal('pending', 10, 2)->nullable();
            $table->enum('transaction_type', ['Open_balance', 'Purchase', 'Pur_return', 'Payment', 'Pay_return'])->default('Purchase');

            $table->softDeletes(); // Optional
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_ledgers');
    }
};
