<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customer_ledgers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('cus_id')->nullable();
            $table->bigInteger('sale_id')->nullable();
            $table->bigInteger('sale_return_id')->nullable();
            $table->bigInteger('pro_id')->nullable();

            $table->string('invoice_date')->nullable();
            $table->string('detail')->nullable();
            $table->string('reason')->nullable();
            $table->string('pro_qty')->nullable();
            $table->decimal('debit')->nullable();
            $table->decimal('credit')->nullable();
            $table->softDeletes();
            $table->enum('transaction_type', ['Open_balance', 'Sale', 'Sale_return', 'Payment', 'Pay_return'])->default('Sale');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customer_ledgers');
    }
};
