<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('saleman_ledgers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('salesman_id')->nullable();
            $table->bigInteger('sale_id')->nullable();
            $table->bigInteger('sale_return_id')->nullable();
            $table->bigInteger('order_id')->nullable();
            $table->bigInteger('order_return_id')->nullable();
            $table->string('pro_id')->nullable();

            $table->string('invoice_date')->nullable();
            $table->string('detail')->nullable();
            $table->string('reason')->nullable();
            $table->string('pro_qty')->nullable();
            $table->decimal('debit')->nullable();
            $table->decimal('credit')->nullable();
            $table->softDeletes();
            $table->enum('transaction_type', ['Open_balance', 'Sale', 'Sale_return', 'Payment', 'Pay_return','Order', 'Order_return'])->default('Order');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('saleman_ledgers');
    }
};
