<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            $table->date('invoice_date');
            $table->bigInteger('cus_id');
            $table->bigInteger('saleman_id');
            $table->bigInteger('bank_id');
            $table->string('detail')->nullable();
            $table->string('Payment_type')->nullable();
            $table->decimal('subtotal', 10, 2);
            $table->decimal('dis_percent', 10, 2)->default(0);
            $table->decimal('dis_amount', 10, 2)->default(0);
            $table->decimal('grand_total', 10, 2);
            $table->decimal('paid', 10, 2);
            $table->decimal('due', 10, 2);
            $table->enum('is_active', [1, 0])->default(1);
            $table->enum('is_deleted', [1, 0])->default(0);
            $table->bigInteger('created_by');
            $table->bigInteger('updated_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales');
    }
};
