<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_details', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('sale_id');
            $table->bigInteger('pro_id');
            $table->string('pro_sku')->nullable();
            $table->string('batch_no')->nullable();
            $table->decimal('purchase_price', 10, 2)->nullable();
            $table->date('date');
            $table->decimal('sale_price', 10, 2);
            $table->string('pro_qty')->nullable();
            $table->decimal('dis_per', 10, 2)->default(0);
            $table->decimal('dis_amount', 10, 2)->default(0);
            $table->decimal('total', 10, 2);
            $table->tinyInteger('is_active')->default(1);
            $table->tinyInteger('is_deleted')->default(0);
            $table->bigInteger('created_by');
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_details');
    }
};
