<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('investor_id')->nullable();
            $table->bigInteger('pro_id')->nullable();
            $table->date('date')->nullable();
            $table->decimal('invested_amount', 10, 2)->nullable();
            $table->decimal('profit_percentage', 10, 2)->nullable();
            $table->enum('status', [1, 0])->default(0);
            $table->enum('payment_type', ['Cash','Bank'])->default('Cash');
            $table->bigInteger('bank_id')->nullable();

            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investments');
    }
};
