<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investment_profits', function (Blueprint $table) {
            $table->id();
            // Relations
            $table->bigInteger('investment_id')->nullable(); // kis investment se link hai
            $table->bigInteger('investor_id')->nullable();   // kis investor ka hai
            $table->bigInteger('sale_id')->nullable();       // kis sale se profit mila
            $table->bigInteger('pro_id')->nullable();        // kis product ka tha

            // Profit detail
            $table->decimal('profit_amount', 12, 2)->default(0);     // earned profit

            // Tracking
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investment_profits');
    }
};
