<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('company_investments', function (Blueprint $table) {
            $table->id();
            $table->decimal('invested_amount', 15, 2);
            $table->decimal('remaining_amount', 15, 2);
            $table->decimal('withdraw_amount', 15, 2);

            $table->date('date')->nullable();
            $table->enum('payment_type', ['Cash','Bank'])->default('Cash');
            $table->bigInteger('bank_id')->nullable();
            // Tracking
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_investments');
    }
};
