<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('productions', function (Blueprint $table) {
            $table->id();
            
            // BOM reference
            $table->bigInteger('bom_id')->nullable();

            // Contractor reference (optional)
            $table->bigInteger('contractor_id')->nullable();
            $table->bigInteger('pro_id')->nullable();

            // Order details
            $table->string('order_number')->unique()->nullable();
            $table->integer('pro_qty')->default(0);
            $table->enum('status', ['pending', 'issue', 'completed', 'cancelled','production'])->default('pending');
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();

            // Costing
            $table->decimal('total_cost', 12, 2)->default(0.00);
            $table->decimal('total_amount', 12, 2)->default(0.00);
            $table->decimal('recover_amount', 12, 2)->default(0.00);
            $table->enum('payment_type', ['Cash','Bank'])->default('Cash');
            $table->bigInteger('bank_id')->nullable();
            // Tracking
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('productions');
    }
};
