<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('salaries', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('employee_id'); // relation with employees
            $table->decimal('salary_per_day', 10, 2)->default(0.00);  // روزانہ کی تنخواہ
            $table->integer('working_days')->default(0.00); // مہینے میں کتنے دن کام کیا
            $table->decimal('advance', 10, 2)->default(0.00); // ایڈوانس
            $table->decimal('total_salary', 10, 2)->default(0.00);   // final حساب
            $table->string('month'); // مثال: "2025-08"
            $table->date('date')->nullable(); // مثال: "2025-08"
            $table->enum('status', ['unpaid', 'paid'])->default('unpaid'); // تنخواہ ملی یا نہیں
            $table->decimal('debit')->nullable();
            $table->decimal('credit')->nullable();
            $table->enum('payment_type', ['Cash','Bank'])->default('Cash');
            $table->bigInteger('bank_id')->nullable();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('salaries');
    }
};
