<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('non_service_stocks', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('opening_stock_id')->nullable();
            $table->bigInteger('sale_return_id')->nullable();
            $table->bigInteger('pro_id')->nullable();
            $table->string('reason')->nullable(); 

            $table->string('adjustment')->nullable();
            $table->date('invoice_date')->nullable();
            $table->decimal('sale_price', 10,2)->default(0.00);
            $table->decimal('sale_return_price', 10,2)->default(0.00);
            $table->integer('stock_in_qty')->nullable();
            $table->integer('stock_out_qty')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('non_service_stocks');
    }
};
