<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quotations', function (Blueprint $table) {
            $table->id();
            $table->date('invoice_date')->nullable();
            $table->bigInteger('cus_id');
            $table->bigInteger('saleman_id');
            $table->bigInteger('bank_id')->nullable();
            $table->string('detail')->nullable();
            $table->enum('Payment_type', ['Cash', 'Bank'])->nullable();
            $table->decimal('subtotal', 10, 2)->default(0.00);
            $table->decimal('dis_percent', 10, 2)->default(0.00);
            $table->decimal('dis_amount', 10, 2)->default(0.00);
            $table->decimal('grand_total', 10, 2)->default(0.00);
            $table->decimal('paid', 10, 2)->default(0.00);
            $table->decimal('due', 10, 2)->default(0.00);
            $table->enum('is_active', [1, 0])->default(1);
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quotations');
    }
};
