<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contracter_ledgers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('contractor_id');
            $table->date('date');
            $table->unsignedTinyInteger('month'); // store 1 to 12
            $table->unsignedSmallInteger('year'); // store 2025 etc
            $table->string('description')->nullable();
            $table->decimal('recovery', 15, 2)->default(0);
            $table->decimal('advance', 15, 2)->default(0);
            $table->decimal('receive_amount', 15, 2)->default(0);
            $table->enum('Payment_type', ['Cash', 'Bank'])->default('Cash');
            $table->bigInteger('bank_id')->nullable();
            $table->bigInteger('created_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contracter_ledgers');
    }
};
