<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('repair_order_details', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('repair_order_id')->nullable(); // kis repairing order se related
            $table->bigInteger('pro_id')->nullable();         // kaunsa product use hua
            $table->bigInteger('pro_sku')->nullable();         // kaunsa product use hua
            $table->decimal('qty', 15, 2)->default(0);        // quantity
            $table->decimal('rate', 15, 2)->default(0);       // per unit rate
            $table->decimal('total', 15, 2)->default(0); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('repair_order_details');
    }
};
